package ru.yandex.autotests.directapi.keywords.get;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.keywords.KeywordFieldEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.general.StatisticsMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordGetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 22.10.15.
 * https://st.yandex-team.ru/TESTIRT-7566
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Description("Проверка возвращения статистики в РСЯ для нового ключевого слова")
@Issue("https://st.yandex-team.ru/DIRECT-47298")
public class GetKeywordsStatisticsNetworkTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_GET;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private long keywordId;

    @Before
    @Step("Подготовка данных для теста")
    public void clearSpentUnits(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
    }

    @Test
    @Description("Возвращение статистики в РСЯ для нового ключевого слова")
    public void newKeywordTest() {
        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGet(
                Arrays.asList(KeywordFieldEnum.ID, KeywordFieldEnum.STATISTICS_NETWORK),
                new KeywordsSelectionCriteriaMap().withIds(keywordId));

        assertThat("вернулась верная статистика в РСЯ для ключевого слова",
                keywords, beanEquivalentV5(Arrays.asList(new KeywordGetItemMap()
                .withStatisticsNetwork(new StatisticsMap()
                        .withClicks(0L)
                        .withImpressions(0L)).getBean())));
    }
}
