package ru.yandex.autotests.directapi.keywords.get;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.general.Statistics;
import com.yandex.direct.api.v5.keywords.KeywordFieldEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.general.StatisticsMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 08.10.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Description("Проверка значений поля Statistic для ключевых слов")
@Issue("https://st.yandex-team.ru/DIRECT-45325")
public class GetKeywordsStatisticsSearchTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String client = KeywordsLogins.SINGLE_CLIENT_GET;

    //группа 184497542
    //ключевые слова со статистикой
    //1499060551
    //1499060553
    //1499060554
    //1499060556
    private static final Long keywordWithStatID = 1499060551L;


    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    public void clearUnits(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @Description("Проверка значений возвращаемых для нового ключевого слова")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3643")
    public void newKeywordTest() {
        log.info("Создадим новую кампанию, группу, объявление и ключевое слово");
        Long campaignID = api.as(client).userSteps.campaignSteps().addDefaultTextCampaign(client);
        Long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(groupID);
        Long keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(groupID);

        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGet(
                Arrays.asList(KeywordFieldEnum.ID, KeywordFieldEnum.STATISTICS_SEARCH),
                new KeywordsSelectionCriteriaMap().withIds(keywordID));
        assumeThat("получили ключевое слово", keywords, hasSize(1));
        Statistics keywordStat = keywords.get(0).getStatisticsSearch();
        assumeThat("получили статистику по ключевому слову", keywordStat, notNullValue());

        StatisticsMap expectedStat = new StatisticsMap()
                .withClicks(0L)
                .withImpressions(0L);
        assertThat("статистика по ключевому слову", keywordStat, beanDifferV5(expectedStat.getBean()));
    }

    //Отключенно. Проверка произведена. Гипотетически может шуметь - нужны активные ключевые слова, по которым есть показы и статистика
    /*@Test
    @Description("Получение реальных значений статистики у активных ключевых слов")
    public void keywordWithStatisticTest() {
        List<KeywordGetItem> keywords = api.as(Logins.SUPER_LOGIN, statClient).userSteps.keywordsSteps().keywordsGet(
                Arrays.asList(KeywordFieldEnum.ID, KeywordFieldEnum.STATISTICS),
                new KeywordsSelectionCriteriaMap().withIds(keywordWithStatID));
        assumeThat("получили ключевые слова", keywords, hasSize(1));
        Statistics keywordStat = keywords.get(0).getStatistics().getValue();
        assumeThat("получили статистику по ключевому слову", keywordStat, notNullValue());

        assertThat("статистика по кликам", keywordStat.getClicks(), greaterThan(0L));
        assertThat("статистика по показам", keywordStat.getImpressions(), greaterThan(0L));
    }*/
}
