package ru.yandex.autotests.directapi.keywords.get;


import java.util.Arrays;

import org.apache.commons.lang3.StringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.keywords.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by chicos on 03.02.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Description("Проверка некорректной структуры запроса Get")
@Tag(TagDictionary.TRUNK)
public class GetKeywordsStructureNegativeTest {
    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT_GET;

    private static long keywordID;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(CLIENT).protocol(ProtocolType.JSON);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepareKeyword() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(groupID);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3645")
    public void noSelectionCriteriaInRequestTest() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.GET,
                new GetRequestMap()
                    .withAllFieldNames(),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(GetRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3646")
    public void noFieldNamesTest() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.GET,
                new GetRequestMap()
                        .withSelectionCriteria(new KeywordsSelectionCriteriaMap().withIds(keywordID)),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        StringUtils.capitalize(GetRequestMap.FIELD_NAMES)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3650")
    public void emptySelectionCriteriaIdsTest() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.GET,
                new GetRequestMap()
                        .withSelectionCriteria(new KeywordsSelectionCriteriaMap())
                        .withAllFieldNames(),
                new Api5Error(4001,
                        Api5ErrorDetails.AT_LEAST_ONE_OF_FOLLOWING_FIELDS_SHOULD_BE_SET));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3647")
    public void invalidStatusEnumTest() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.GET,
                new GetRequestMap()
                        .withSelectionCriteria(new KeywordsSelectionCriteriaMap()
                                .withIds(keywordID)
                                .withStatuses("INVALID_VALUE"))
                        .withAllFieldNames(),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        path(GetRequestMap.SELECTION_CRITERIA, KeywordsSelectionCriteriaMap.STATUSES),
                        "DRAFT, ACCEPTED, REJECTED"));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3648")
    public void invalidStateEnumTest() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.GET,
                new GetRequestMap()
                        .withSelectionCriteria(new KeywordsSelectionCriteriaMap()
                                .withIds(keywordID)
                                .withStates("INVALID_VALUE"))
                        .withAllFieldNames(),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        path(GetRequestMap.SELECTION_CRITERIA, KeywordsSelectionCriteriaMap.STATES),
                        "OFF, ON, SUSPENDED"));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3652")
    public void maxKeywordIdsTest() {
        Long[] fakeIds = new Long[KeywordsSelectionCriteriaMap.IDS_MAX_LENGTH + 1];
        Arrays.fill(fakeIds, 0, KeywordsSelectionCriteriaMap.IDS_MAX_LENGTH + 1, 123456L);

        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.GET,
                new GetRequestMap()
                        .withSelectionCriteria(new KeywordsSelectionCriteriaMap()
                                .withIds(fakeIds))
                        .withAllFieldNames(),
                new Api5Error(4001,
                        Api5ErrorDetailsJava.MAX_IDS_IN_SELECTION,
                        path(GetRequestMap.SELECTION_CRITERIA, KeywordsSelectionCriteriaMap.IDS)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3653")
    public void maxAdGroupIdsTest() {
        Long[] fakeIds = new Long[KeywordsSelectionCriteriaMap.ADGROUP_IDS_MAX_LENGTH + 1];
        Arrays.fill(fakeIds, 0, KeywordsSelectionCriteriaMap.ADGROUP_IDS_MAX_LENGTH + 1, 123456L);

        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.GET,
                new GetRequestMap()
                        .withSelectionCriteria(new KeywordsSelectionCriteriaMap()
                                .withAdGroupIds(fakeIds))
                        .withAllFieldNames(),
                new Api5Error(4001,
                        Api5ErrorDetailsJava.MAX_IDS_IN_SELECTION,
                        path(GetRequestMap.SELECTION_CRITERIA,
                                KeywordsSelectionCriteriaMap.ADGROUP_IDS)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3654")
    public void maxCampaignIdsTest() {
        Long[] fakeIds = new Long[KeywordsSelectionCriteriaMap.CAMPAIGN_IDS__MAX_LENGTH + 1];
        Arrays.fill(fakeIds, 0, KeywordsSelectionCriteriaMap.CAMPAIGN_IDS__MAX_LENGTH + 1, 123456L);

        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.GET,
                new GetRequestMap()
                        .withSelectionCriteria(new KeywordsSelectionCriteriaMap()
                                .withCampaignIds(fakeIds))
                        .withAllFieldNames(),

                new Api5Error(4001,
                        Api5ErrorDetailsJava.MAX_IDS_IN_SELECTION,
                        path(GetRequestMap.SELECTION_CRITERIA,
                                KeywordsSelectionCriteriaMap.CAMPAIGN_IDS)));
    }
}
