package ru.yandex.autotests.directapi.keywords.get;


import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 27.02.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Description("Проверка возвращаемых значений параметров UserParam1 и UserParam2")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetKeywordsUserParamTest {
    private static LogSteps log = LogSteps.getLogger(GetKeywordsUserParamTest.class);
    private static final String client = KeywordsLogins.SINGLE_CLIENT_GET;

    private long keywordID;
    private static Long campaignID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String fieldName;

    @Parameterized.Parameter(value = 1)
    public String description;

    @Parameterized.Parameter(value = 2)
    public String fieldValue;

    @Parameterized.Parameters(name = "field = {0}, value = {1}")
    public static Collection fieldsValue() throws UnsupportedEncodingException {
        Object[][] data = new Object[][]{
                {KeywordAddMap.USER_PARAM_1, "Пустая строка", ""},
                {KeywordAddMap.USER_PARAM_1, "Строка из пробелов", "  "},
                {KeywordAddMap.USER_PARAM_1, "Латинские символы", RandomStringUtils.randomAlphabetic(10)},
                {KeywordAddMap.USER_PARAM_1, "Цифровые символы", RandomStringUtils.randomAlphabetic(10)},
                {KeywordAddMap.USER_PARAM_1, "Латинские и цифровые символы", RandomStringUtils.randomAlphanumeric(10)},
                {KeywordAddMap.USER_PARAM_1, "Кириллические символы", "параметр"},
                {KeywordAddMap.USER_PARAM_1, "Турецкие символы", "türkçe"},
                {KeywordAddMap.USER_PARAM_1, "Спецсимволы", "param/param?key=1"},
                {KeywordAddMap.USER_PARAM_1, "Строка с пробелом", RandomStringUtils.randomAlphabetic(5) + " " + RandomStringUtils.randomAlphabetic(5)},
                {KeywordAddMap.USER_PARAM_1, "Несколько пробелов", " " + RandomStringUtils.randomAlphabetic(5) + "  "},
                {KeywordAddMap.USER_PARAM_1, "Минимальная длина", RandomStringUtils.randomAlphabetic(1)},
                {KeywordAddMap.USER_PARAM_1, "Максимальная длина", RandomStringUtils.randomAlphabetic(KeywordAddMap.MAX_USER_PARAM_LENGTH)},

                {KeywordAddMap.USER_PARAM_2, "Пустая строка", ""},
                {KeywordAddMap.USER_PARAM_2, "Строка из пробелов", "  "},
                {KeywordAddMap.USER_PARAM_2, "Латинские символы", RandomStringUtils.randomAlphabetic(10)},
                {KeywordAddMap.USER_PARAM_2, "Цифровые символы", RandomStringUtils.randomAlphabetic(10)},
                {KeywordAddMap.USER_PARAM_2, "Латинские и цифровые символы", RandomStringUtils.randomAlphanumeric(10)},
                {KeywordAddMap.USER_PARAM_2, "Кириллические символы", "параметр"},
                {KeywordAddMap.USER_PARAM_2, "Турецкие символы", "türkçe"},
                {KeywordAddMap.USER_PARAM_2, "Спецсимволы", "param/param?key=1"},
                {KeywordAddMap.USER_PARAM_2, "Строка с пробелом", RandomStringUtils.randomAlphabetic(5) + " " + RandomStringUtils.randomAlphabetic(5)},
                {KeywordAddMap.USER_PARAM_2, "Несколько пробелов", " " + RandomStringUtils.randomAlphabetic(5) + "  "},
                {KeywordAddMap.USER_PARAM_2, "Минимальная длина", RandomStringUtils.randomAlphabetic(1)},
                {KeywordAddMap.USER_PARAM_2, "Максимальная длина", RandomStringUtils.randomAlphabetic(KeywordAddMap.MAX_USER_PARAM_LENGTH)}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Before
    public void prepareKeyword() {
        long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        KeywordAddMap keywordMap = new KeywordAddMap().shortKeyword().withAdGroupId(groupID);
        ReflectionUtils.setBeanMapFieldValue(keywordMap, "with" + StringUtils.capitalize(fieldName), fieldValue);
        List<Long> keywordIds = api.userSteps.keywordsSteps().keywordsAdd(keywordMap);
        assumeThat("добавлено ключевое слово", keywordIds, hasSize(1));
        keywordID = keywordIds.get(0);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3663")
    public void userParamTest() {
        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGetById(keywordID);
        assumeThat("получено ключевое слово", keywords, hasSize(1));

        KeywordGetItemMap keywordMap = new KeywordGetItemMap();
        ReflectionUtils.setBeanMapFieldValue(keywordMap, "with" + StringUtils.capitalize(fieldName), fieldValue.trim());
        assertThat("получено ключевое слово", keywords.get(0), beanEquivalentV5(keywordMap.getBean()));
    }
}
