package ru.yandex.autotests.directapi.keywords.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.keywords.KeywordFieldEnum;
import org.joda.time.DateTime;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.keywords.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by ginger on 04.08.16.
 * https://st.yandex-team.ru/TESTIRT-9939
 */
@Aqua.Test
@Description("Проверка валидации неверного формата ModifiedSince")
@Issue("https://st.yandex-team.ru/DIRECT-56416")
@Features(KeywordsFeatures.GET)
@RunWith(Parameterized.class)
public class ModifiedSinceNegativeTest {

    private static String CLIENT = KeywordsLogins.SINGLE_CLIENT;
    private static final String PATTERN_DB = "yyyy'-'MM'-'dd HH':'mm':'ss.S";
    private static long keywordId = 123;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String modifiedSince;

    @Parameterized.Parameter(value = 1)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "ModifiedSince = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"",
                        new Api5Error(4000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
                                capitalize(KeywordsSelectionCriteriaMap.MODIFIED_SINCE))},
                {"0000-00-00T00:00:00Z",
                        new Api5Error(4000, Api5ErrorDetailsJava.CORRECT_DATE_MUST_BE_SPECIFIED,
                                capitalize(KeywordsSelectionCriteriaMap.MODIFIED_SINCE))},
                {"abc",
                        new Api5Error(4000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
                                capitalize(KeywordsSelectionCriteriaMap.MODIFIED_SINCE))},
                {DateTime.now().toString(PATTERN_DB),
                        new Api5Error(4000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
                                capitalize(KeywordsSelectionCriteriaMap.MODIFIED_SINCE))},

        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareKeyword() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void invalidFormatOfModifiedSince() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.GET,
                new GetRequestMap()
                        .withSelectionCriteria(new KeywordsSelectionCriteriaMap()
                                .withIds(keywordId)
                                .withModifiedSince(modifiedSince))
                        .withFieldNames(KeywordFieldEnum.ID),
                expectedError
        );
    }
}
