package ru.yandex.autotests.directapi.keywords.get.json;


import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.keywords.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


/**
 * Created by chicos on 10.04.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Description("Валидация некорректных значений вместо типа Enum (FieldNames)")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetKeywordsJsonValidationEnumTest {
    private static LogSteps log = LogSteps.getLogger(GetKeywordsJsonValidationEnumTest.class);
    private static final String client = KeywordsLogins.SINGLE_CLIENT_GET;

    private static long keywordID;
    private static long groupID;
    private static Long campaignID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client).protocol(ProtocolType.JSON);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public Object filedsValue;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection longValues() {
        Object[][] data = new Object[][]{
                {"Массив вместо значения в массиве FieldNames", Arrays.asList(1234L)},
                {"Пустой объект вместо значения в массиве FieldNames", new JSONObject()},
                {"Вещественное число вместо значения FieldNames", 2.13F}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareKeyword() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(groupID);
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3665")
    public void arrayValueTest() {
        JSONObject request = new JSONObject();

        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(StringUtils.capitalize(KeywordsSelectionCriteriaMap.IDS), Arrays.asList(keywordID));

        request.put(StringUtils.capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(StringUtils.capitalize(GetRequestMap.FIELD_NAMES), Arrays.asList(filedsValue));

        api.userSteps.keywordsSteps().shouldGetJSONErrorOn(
                ServiceNames.KEYWORDS,
                client,
                Action.GET,
                request,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        StringUtils.capitalize(GetRequestMap.FIELD_NAMES),
                        "Id, Keyword, State, Status, AdGroupId, CampaignId, Bid, ContextBid, StrategyPriority, " +
                                "UserParam1, UserParam2, Productivity, StatisticsSearch, StatisticsNetwork, " +
                                "ServingStatus, AutotargetingCategories"));
    }
}
