package ru.yandex.autotests.directapi.keywords.get.json;


import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.keywords.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordGetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;


/**
 * Created by chicos on 10.04.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Description("Валидация некорректных значений вместо типа Long")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetKeywordsJsonValidationLongTest {
    private static LogSteps log = LogSteps.getLogger(GetKeywordsJsonValidationLongTest.class);
    private static final String client = KeywordsLogins.SINGLE_CLIENT_GET;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client).protocol(ProtocolType.JSON);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public Object longValue;

    @Parameterized.Parameter(value = 2)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection longValues() {
        Object[][] data = new Object[][]{
                {"Массив вместо значения в массиве Ids", Arrays.asList(1234L),
                        new Api5Error(8000,
                                Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                                path(GetRequestMap.SELECTION_CRITERIA, KeywordsSelectionCriteriaMap.IDS))},
                {"Пустой объект вместо значения в массиве Ids", new JSONObject(),
                        new Api5Error(8000,
                                Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                                path(GetRequestMap.SELECTION_CRITERIA, KeywordsSelectionCriteriaMap.IDS))},
                {"Вещественное число вместо значения Ids", 2.13F,
                        new Api5Error(8000,
                                Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD2,
                                path(GetRequestMap.SELECTION_CRITERIA, KeywordsSelectionCriteriaMap.IDS))}
        };
        return Arrays.asList(data);
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3666")
    public void arrayValueTest() {
        JSONObject request = new JSONObject();

        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(StringUtils.capitalize(KeywordsSelectionCriteriaMap.IDS), Arrays.asList(longValue));

        request.put(StringUtils.capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(StringUtils.capitalize(GetRequestMap.FIELD_NAMES), Arrays.asList(
                StringUtils.capitalize(KeywordGetItemMap.ID),
                StringUtils.capitalize(KeywordGetItemMap.ADGROUP_ID)));

        api.userSteps.keywordsSteps().shouldGetJSONErrorOn(
                ServiceNames.KEYWORDS,
                client,
                Action.GET,
                request,
                expectedError);
    }
}
