package ru.yandex.autotests.directapi.keywords.get.json;


import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.keywords.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordGetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;


/**
 * Created by chicos on 10.04.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Description("Валидация некорректных значений вместо элемента Page")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetKeywordsJsonValidationObjectTest {
    private static LogSteps log = LogSteps.getLogger(GetKeywordsJsonValidationObjectTest.class);
    private static final String client = KeywordsLogins.SINGLE_CLIENT_GET;

    private static long keywordID;
    private static long groupID;
    private static Long campaignID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client).protocol(ProtocolType.JSON);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public Object pageValue;

    @Parameterized.Parameter(value = 2)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection longValues() {
        Object[][] data = new Object[][]{
                {"Массив вместо элемента Page", Arrays.asList(1234L),
                        new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                path(GetRequestMap.PAGE))},
                {"Вещественное число вместо элемента Page", 2.13F,
                        new Api5Error(8000, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD2,
                                path(GetRequestMap.PAGE))},
                {"Целое число вместо элемента Page", 1234L,
                        new Api5Error(8000, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD2,
                                path(GetRequestMap.PAGE))},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareKeyword() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(groupID);
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3667")
    public void arrayValueTest() {
        JSONObject request = new JSONObject();

        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(StringUtils.capitalize(KeywordsSelectionCriteriaMap.IDS), Arrays.asList(keywordID));

        request.put(StringUtils.capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(StringUtils.capitalize(GetRequestMap.FIELD_NAMES), Arrays.asList(
                StringUtils.capitalize(KeywordGetItemMap.ID),
                StringUtils.capitalize(KeywordGetItemMap.ADGROUP_ID)));

        request.put(StringUtils.capitalize(GetRequestMap.PAGE), pageValue);

        api.userSteps.keywordsSteps().shouldGetJSONErrorOn(
                ServiceNames.KEYWORDS,
                client,
                Action.GET,
                request,
                expectedError);
    }
}
