package ru.yandex.autotests.directapi.keywords.get.keyword;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 24.04.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Description("Запрос ключевых слов, созданных со сложными сочетаниями скобок [] - фиксации порядка слов")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetKeywordsComplicatedBracketsTest {
    private static LogSteps log = LogSteps.getLogger(GetKeywordsComplicatedBracketsTest.class);
    private static final String client = KeywordsLogins.SINGLE_CLIENT_GET;
    private static Long campaignID;

    private long groupID;
    private long keywordID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String keywordValue;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection fields() {
        Object[][] data = new Object[][]{
                {"[билет в питер]"},
                {"[питер]"},
                {"[!питер]"},
                {"\"[билет в питер]\""},
                {"купить [билет в питер]"},
                {"\"купить [билет в питер]\""},
                {"купить [билет в питер] -авиабилет"},
                {"купить [билет в !питер]"},
                {"[билет на самолет] !питер -купить"},
                {"купить [билет в !питере] +на спектакль"},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign(){
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void prepareKeyword(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        keywordID = api.userSteps.keywordsSteps().addKeyword(groupID, keywordValue);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3668")
    public void getKeywordsTest() {
        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGetById(keywordID);
        assumeThat("получили ключевое слово", keywords, hasSize(1));

        KeywordGetItemMap expectedWord = new KeywordGetItemMap().withKeyword(keywordValue);
        assertThat("ключевое слово содержит корректную фразу", keywords.get(0), beanEquivalentV5(expectedWord.getBean()));
    }
}
