package ru.yandex.autotests.directapi.keywords.get.keyword;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 15.03.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Description("Запрос ключевых слов, созданных с различными значениями параметра Keyword")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetKeywordsKeywordTest {
    private static LogSteps log = LogSteps.getLogger(GetKeywordsKeywordTest.class);
    private static final String client = KeywordsLogins.SINGLE_CLIENT_GET;
    private static Long campaignID;

    private long groupID;
    private long keywordID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String keywordValue;

    @Parameterized.Parameter(value = 2)
    public String expectedValue;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection fields() {
        Object[][] data = new Object[][]{
                {"Латинские символы",
                        "window",
                        "window"},
                {"Кириллические символы",
                        "проездной",
                        "проездной"},
                {"Турецкие символы",
                        "müthişreklamÇĞğÖŞÜ",
                        "müthişreklamÇĞğÖŞÜ"},
                {"Цифровые символы",
                        "65324579644",
                        "65324579644"},
                {"Латинские и цифровые символы",
                        "4fdfFd54fd5145fDDw",
                        "4fdfFd54fd5145fDDw"},
                {"Ключевое заканчивается символом .",
                        "кирпич.",
                        "кирпич."},
                {"Использование символа '",
                        "rock'n'roll детка",
                        "rock'n'roll детка"},
                {"Ключевое состоящее из 7 слов",
                        "неожиданные структурные перекосы экономически опосредованной объективной реальности",
                        "неожиданные структурные перекосы экономически опосредованной объективной реальности"},
                {"Пробелы в начале и конце",
                        "    рефераты ",
                        "рефераты"},
                {"Пробел в середине",
                        "пластиковые  окна",
                        "пластиковые окна"},
                {"Ключевое содержит стоп-слово",
                        "мир всем",
                        "мир всем"},
                {"Использование стоп-слов",
                        "товары +для автомобиля",
                        "товары +для автомобиля"},
                {"Фиксация словоформы одиночное",
                        "!искусный",
                        "!искусный"},
                {"Фиксация словоформы несколько",
                        "макияж !трафарет",
                        "макияж !трафарет"},
                {"С учётом словоформ одиночное",
                        "\"влюбленный\"",
                        "\"влюбленный\""},
                {"C учётом словоформ несколько",
                        "\"котята шредингера купить\"",
                        "\"котята шредингера купить\""},
                {"С учетом словоформ и фиксацией",
                        "\"!пенобетон\"",
                        "\"!пенобетон\""},
                {"C учётом словоформ и стоп-слов",
                        "\"решетка +для камина\"",
                        "\"решетка для камина\""},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign(){
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Before
    public void prepareGroup(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        keywordID = api.userSteps.keywordsSteps().addKeyword(groupID, keywordValue);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3669")
    public void keywordsTest() {
        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGetById(keywordID);
        assumeThat("получили ключевое слово", keywords, hasSize(1));

        KeywordGetItemMap expectedWord = new KeywordGetItemMap().withKeyword(expectedValue);
        assertThat("ключевое слово ", keywords.get(0), beanEquivalentV5(expectedWord.getBean()));
    }
}
