package ru.yandex.autotests.directapi.keywords.get.keyword;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.anyOf;
import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 15.03.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Description("Запрос ключевых слов, созданных с минус-словами")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetKeywordsMinusWordTest {
    private static LogSteps log = LogSteps.getLogger(GetKeywordsMinusWordTest.class);
    private static final String client = KeywordsLogins.SINGLE_CLIENT_GET;
    private static Long campaignID;

    private long keywordID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String keywordValue;

    @Parameterized.Parameter(value = 2)
    public String expectedValue;

    @Parameterized.Parameter(value = 3)
    public String expectedJavaValue;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection fields() {
        Object[][] data = new Object[][]{
                {"Ключевое с минус-словом",
                        "остекление -балкон",
                        "остекление -балкон",
                        "остекление -балкон"},
                {"Ключевое с минусом из стоп-слова",
                        "мультики -все",
                        "мультики -!все",
                        "мультики -!все"},
                {"Ключевое с минусом из стоп-слова ",
                        "мультики -+все",
                        "мультики -+все",
                        "мультики -+все"},
                {"Ключевое с минусом из стоп-слова с символом 'ё'",
                        "хаски -всё",
                        "хаски -!всё",
                        "хаски -!все"},
                {"Ключевое с несколькими минус-словами",
                        "остекление -окно -витраж -балкон",
                        "остекление -балкон -витраж -окно",
                        "остекление -окно -витраж -балкон"},
                {"Ключевое с одинаковыми минус-словами",
                        "ремонт -бесплатный -бесплатный",
                        "ремонт -бесплатный",
                        "ремонт -бесплатный"},
                {"Ключевые слова с минус-словом",
                        "остекление лоджий -срочное",
                        "остекление лоджий -срочное",
                        "остекление лоджий -срочное"},
                {"Минус-слово с фиксацией словоформы",
                        "остекление -!балконов",
                        "остекление -!балконов",
                        "остекление -!балконов"}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        keywordID = api.userSteps.keywordsSteps().addKeyword(groupID, keywordValue);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3670")
    public void getKeywordsTest() {
        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGetById(keywordID);
        assumeThat("получили ключевое слово", keywords, hasSize(1));

        KeywordGetItemMap expectedWord = new KeywordGetItemMap().withKeyword(expectedValue);
        KeywordGetItemMap expectedJavaWord = new KeywordGetItemMap().withKeyword(expectedJavaValue);
        assertThat("ключевое слово ", keywords.get(0),
                anyOf(
                        beanEquivalentV5(expectedWord.getBean()),
                        beanEquivalentV5(expectedJavaWord.getBean()))
        );
    }
}
