package ru.yandex.autotests.directapi.keywords.resume;

import org.apache.commons.lang3.ArrayUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.keywords.ResumeRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 26.03.15.
 * https://st.yandex-team.ru/TESTIRT-4391
 */
@Aqua.Test
@Features(KeywordsFeatures.RESUME)
@Issue("https://st.yandex-team.ru/DIRECT-39271")
@Description("Попытка включения ключевых слов, число которых больше максимального")
@Tag(TagDictionary.TRUNK)
public class ResumeIdsLengthRestrictionNegativeTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_RESUME;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Включить ключевые слова, число которых больше " + IdsCriteriaMap.IDS_MAX_LENGTH + " за один запрос")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3671")
    public void resumeGreaterThanMaxKeywordsWithOneRequest() {
        Long[] keywordIDs = ArrayUtils.toObject(new long[IdsCriteriaMap.IDS_MAX_LENGTH + 1]);

        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.RESUME,
                new ResumeRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(keywordIDs)),
                new Api5Error(9300,
                        Api5ErrorDetails.KEYWORD_UPDATE_REQUEST_LIMIT,
                        IdsCriteriaMap.IDS_MAX_LENGTH));
    }
}
