package ru.yandex.autotests.directapi.keywords.resume;

import org.apache.commons.lang3.ArrayUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.ResumeRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;

/**
 * Created by semkagtn on 12.03.15.
 * https://st.yandex-team.ru/TESTIRT-4391
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Issue("https://st.yandex-team.ru/DIRECT-39271")
@Description("Включение максимального числа ключевых слов за один запрос")
public class ResumeIdsLengthRestrictionTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_RESUME;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Включить " + IdsCriteriaMap.IDS_MAX_LENGTH + " ключевых слов за один запрос")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3672")
    public void resumeMaxKeywordsWithOneRequest() {
        Long[] keywordIDs = ArrayUtils.toObject(new long[IdsCriteriaMap.IDS_MAX_LENGTH]);
        for (int i = 0; i < keywordIDs.length; i++) {
            keywordIDs[i] = (long) -i;
        }

        ExpectedResult[] expectedResults = new ExpectedResult[IdsCriteriaMap.IDS_MAX_LENGTH];
        Arrays.fill(expectedResults, ExpectedResult.errors(
                new Notification(8800, Api5ErrorDetails.KEYWORD_NOT_FOUND)));

        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.RESUME,
                new ResumeRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(keywordIDs)),
                expectedResults);
    }
}
