package ru.yandex.autotests.directapi.keywords.resume;

import java.util.List;

import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.ResumeRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.contains;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 2/27/15.
 * https://st.yandex-team.ru/TESTIRT-4391
 */
@Aqua.Test
@Features(KeywordsFeatures.RESUME)
@Issue("https://st.yandex-team.ru/DIRECT-39271")
@Description("Проверка работоспособности метода Keywords.Resume, когда переданы валидный и невалидный объекты")
@Tag(TagDictionary.TRUNK)
public class ResumeMultipleErrorTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_RESUME;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN).protocol(ProtocolType.JSON);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long keywordID;
    private long nonexistentKeywordID;

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaingID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaingID);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupID);
        keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupID);
        api.userSteps.keywordsSteps().setKeywordStatus(adGroupID, keywordID, StatusEnum.ACCEPTED);
        nonexistentKeywordID = keywordID + 500001;
        api.userSteps.keywordsSteps().keywordsSuspend(keywordID);
        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGetById(keywordID);
        List<StateEnum> states = extract(keywords, on(KeywordGetItem.class).getState());
        assumeThat("ключевое слово находится в статусе Suspended", states, contains(StateEnum.SUSPENDED));
    }

    @Test
    @Description("Существующий и несуществующий идентификаторы в запросе на включение ключевых слов")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3686")
    public void existentAndNonexistentIdsInRequest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.RESUME,
                new ResumeRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(keywordID, nonexistentKeywordID)),
                ExpectedResult.success(keywordID),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.KEYWORD_NOT_FOUND)));

        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGetById(keywordID);
        List<StateEnum> states = extract(keywords, on(KeywordGetItem.class).getState());
        assumeThat("ключевое слово находится в статусе On", states, contains(StateEnum.ON));
    }
}
