package ru.yandex.autotests.directapi.keywords.resume;

import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.ResumeRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 3/5/15.
 * https://st.yandex-team.ru/TESTIRT-4391
 */
@Aqua.Test
@Features(KeywordsFeatures.RESUME)
@Issue("https://st.yandex-team.ru/DIRECT-39271")
@Description("Включение ключевого слова и автотаргетинга, которые уже включены")
@Tag(TagDictionary.TRUNK)
public class ResumeResumedKeywordAndAutotargetingTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_RESUME;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN).protocol(ProtocolType.JSON);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adGroupId;
    private long keywordID;

    @BeforeClass
    public static void createAdGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
    }

    @Test
    @Description("Попытка включить уже включенное ключевое слово должно порождать ошибку")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3687")
    public void resumeResumedKeyword() {
        keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        api.userSteps.keywordsSteps().setKeywordStatus(adGroupId, keywordID, StatusEnum.ACCEPTED);
        api.userSteps.keywordsSteps().keywordsResume(keywordID);

        assumeThat("ключевое слово находится в статусе On",
                api.userSteps.keywordsSteps().getKeywordState(keywordID),
                equalTo(StateEnum.ON)
        );
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.RESUME,
                new ResumeRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(keywordID)),
                ExpectedResult.warnings(new Notification(10241)));
    }

    @Test
    @Description("Попытка включить уже включенный автотаргетинг должна порождать предупреждение")
    public void resumeResumedAutotargeting() {
        Long autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
        api.userSteps.keywordsSteps().keywordsResume(autotargetingId);

        assumeThat("автотаргетинг находится в статусе On",
                api.userSteps.keywordsSteps().getKeywordState(autotargetingId),
                equalTo(StateEnum.ON)
        );
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.RESUME,
                new ResumeRequestMap().withSelectionCriteria(
                        new IdsCriteriaMap().withIds(autotargetingId)
                ),
                ExpectedResult.warnings(new Notification(10245))
        );
    }
}
