package ru.yandex.autotests.directapi.keywords.resume;

import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.model.api5.keywords.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.ResumeRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 12.05.15.
 * https://st.yandex-team.ru/TESTIRT-4391
 */
@Aqua.Test
@Features(KeywordsFeatures.RESUME)
@Issue("https://st.yandex-team.ru/DIRECT-39271")
@Description("Запросы на запуск ключевых слов через протокол SOAP")
public class ResumeSoapTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_RESUME;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN).protocol(ProtocolType.SOAP);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Запрос без поля SelectionCriteria в запросе на включение ключевых слов")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3691")
    public void requestWithoutSelectionCriteria() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.RESUME,
                new ResumeRequestMap()
                        .withSelectionCriteria(null),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(DeleteRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @Description("Запрос без поля SelectionCriteria.Ids в запросе на включение ключевых слов")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3690")
    public void requestWithoutIds() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.RESUME,
                new ResumeRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()),
                JavaOrPerlApi5Error
                        .java(new Api5Error(8000,
                                Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                                StringUtils.capitalize(DeleteRequestMap.SELECTION_CRITERIA)))
                        .perl(new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                                StringUtils.capitalize(DeleteRequestMap.SELECTION_CRITERIA),
                                StringUtils.capitalize(IdsCriteriaMap.IDS))));
    }

    @Test
    @Description("Валидный запрос на запуск ключевых слов")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3692")
    public void correctRequest() {
        api.protocol(ProtocolType.JSON);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupID);
        long keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupID);
        api.userSteps.keywordsSteps().keywordsSuspend(keywordID);

        api.protocol(ProtocolType.SOAP);
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.RESUME,
                new ResumeRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(keywordID)),
                ExpectedResult.success(keywordID));
    }
}
