package ru.yandex.autotests.directapi.keywords.resume;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.ResumeRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by semkagtn on 2/27/15.
 * https://st.yandex-team.ru/TESTIRT-4391
 */
@Aqua.Test
@Features(KeywordsFeatures.RESUME)
@Issue("https://st.yandex-team.ru/DIRECT-39271")
@Description("Неверные идентификаторы ключевых слов в методу Keywords.Resume")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class ResumeWrongIdsTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_RESUME;
    private static final String ANOTHER_LOGIN = KeywordsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public long wrongId;

    @Parameterized.Parameter(2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0} - {1}")
    public static Collection<Object[]> data() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(ANOTHER_LOGIN);

        api.as(LOGIN);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        long keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupID);
        long nonexistentKeywordID = keywordID + 100000;
        long deletedKeywordID = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupID);
        api.userSteps.keywordsSteps().keywordsDelete(deletedKeywordID);

        api.as(ANOTHER_LOGIN);
        Long anotherCampaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(ANOTHER_LOGIN);
        long anotherAdGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(anotherCampaignID);
        api.userSteps.keywordsSteps().addDefaultKeyword(anotherAdGroupID);
        long anotherKeywordID = api.userSteps.keywordsSteps().addDefaultKeyword(anotherAdGroupID);

        api.as(LOGIN);

        return Arrays.asList(new Object[][]{
                {"нулевой идетификатор в запросе на включение ключевых слов", 0,
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.ID_MUST_BE_POSITIVE_INTEGER,
                                        path(KeywordUpdateMap.ID)))
                },
                {"отрицательный идетификатор в запросе на включение ключевых слов", -1,
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.ID_MUST_BE_POSITIVE_INTEGER,
                                        path(KeywordUpdateMap.ID)))
                },
                {"несуществующий идетификатор в запросе на включение ключевых слов", nonexistentKeywordID,
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.KEYWORD_NOT_FOUND))
                },
                {"удалённый идетификатор в запросе на включение ключевых слов", deletedKeywordID,
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.KEYWORD_NOT_FOUND))
                },
                {"чужой идетификатор в запросе на включение ключевых слов", anotherKeywordID,
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.KEYWORD_NOT_FOUND))
                },
        });
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3703")
    public void requestForResumeWithWrongId() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.RESUME,
                new ResumeRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(wrongId)),
                expectedResult);
    }
}
