package ru.yandex.autotests.directapi.keywords.suspend;

import org.apache.commons.lang3.ArrayUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.model.api5.keywords.SuspendRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 26.03.15.
 * https://st.yandex-team.ru/TESTIRT-4391
 */
@Aqua.Test
@Features(KeywordsFeatures.SUSPEND)
@Issue("https://st.yandex-team.ru/DIRECT-39271")
@Description("Попытка остановки ключевых слов, число которых больше максимального")
public class SuspendIdsLengthRestrictionNegativeTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_SUSPEND;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Отключить ключевые слова, число которых больше " + IdsCriteriaMap.IDS_MAX_LENGTH + " за один запрос")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3704")
    public void suspendGreaterThanMaxKeywordsWithOneRequest() {
        Long[] keywordIDs = ArrayUtils.toObject(new long[IdsCriteriaMap.IDS_MAX_LENGTH + 1]);

        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.SUSPEND,
                new SuspendRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(keywordIDs)),
                JavaOrPerlApi5Error
                        .java(
                                new Api5Error(9300,
                                        Api5ErrorDetails.KEYWORD_UPDATE_REQUEST_LIMIT,
                                        IdsCriteriaMap.IDS_MAX_LENGTH))
                        .perl(
                                new Api5Error(9300,
                                        Api5ErrorDetails.KEYWORDS_SUSPEND_LIMIT_EXCEEDED,
                                        IdsCriteriaMap.IDS_MAX_LENGTH)));
    }
}
