package ru.yandex.autotests.directapi.keywords.suspend;

import java.util.stream.Stream;

import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.keywords.SuspendRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.stream.Collectors.joining;
import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 2/27/15.
 * https://st.yandex-team.ru/TESTIRT-4390
 */
@Aqua.Test
@Features(KeywordsFeatures.SUSPEND)
@Stories(ApiStories.JSON5)
@Issue("https://st.yandex-team.ru/DIRECT-39271")
@Description("Валидация JSON-запроса для метода Keywords.Suspend")
public class SuspendJsonValidationTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_SUSPEND;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN).protocol(ProtocolType.JSON);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Массив в поле SelectionCriteria")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3706")
    public void arrayInSelectionCriteriaField() {
        JSONObject request = new JSONObject();
        Object selectionCriteria = new IdsCriteriaMap()
                .withIds(0l).getBean();
        request.put(StringUtils.capitalize(SuspendRequestMap.SELECTION_CRITERIA), new Object[]{selectionCriteria});
        api.userSteps.keywordsSteps().shouldGetJSONErrorOn(
                ServiceNames.KEYWORDS,
                LOGIN,
                Action.SUSPEND,
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        StringUtils.capitalize(SuspendRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @Description("Не массив в поле SelectionCriteria.Ids")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3708")
    public void notAnArrayInIdsField() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(StringUtils.capitalize(IdsCriteriaMap.IDS), 0l);
        request.put(StringUtils.capitalize(SuspendRequestMap.SELECTION_CRITERIA), selectionCriteria);
        api.userSteps.keywordsSteps().shouldGetJSONErrorOn(
                ServiceNames.KEYWORDS,
                LOGIN,
                Action.SUSPEND,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        Stream.of(capitalize(SuspendRequestMap.SELECTION_CRITERIA), capitalize(IdsCriteriaMap.IDS))
                                .collect(joining("."))));
    }

    @Test
    @Description("Строка внутри массива SelectionCriteria.Ids")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3707")
    public void stringInIdsArray() {
        String value = "WrongId";
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(StringUtils.capitalize(IdsCriteriaMap.IDS), new String[]{value});
        request.put(StringUtils.capitalize(SuspendRequestMap.SELECTION_CRITERIA), selectionCriteria);
        api.userSteps.keywordsSteps().shouldGetJSONErrorOn(
                ServiceNames.KEYWORDS,
                LOGIN,
                Action.SUSPEND,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        Stream.of(capitalize(SuspendRequestMap.SELECTION_CRITERIA), capitalize(IdsCriteriaMap.IDS))
                                .collect(joining("."))));
    }

    @Test
    @Description("Массив внутри массива SelectionCriteria.Ids")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3709")
    public void arrayInIdsArray() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(StringUtils.capitalize(IdsCriteriaMap.IDS), new Long[][]{new Long[]{0l}});
        request.put(StringUtils.capitalize(SuspendRequestMap.SELECTION_CRITERIA), selectionCriteria);
        api.userSteps.keywordsSteps().shouldGetJSONErrorOn(
                ServiceNames.KEYWORDS,
                LOGIN,
                Action.SUSPEND,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        Stream.of(capitalize(SuspendRequestMap.SELECTION_CRITERIA), capitalize(IdsCriteriaMap.IDS))
                                .collect(joining("."))));
    }
}
