package ru.yandex.autotests.directapi.keywords.suspend;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordGetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.keywords.SuspendRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static ch.lambdaj.Lambda.sort;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.everyItem;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by semkagtn on 12.03.15.
 * https://st.yandex-team.ru/TESTIRT-4391
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-39271")
@Description("Одинаковые идетификаторы в запросе на отключение ключевых слов")
public class SuspendSameIdsTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_SUSPEND;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long firstKeywordID;
    private long secondKeywordID;

    @Before
    @Step("Подготовка данных для теста")
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
        List<Long> keywordIDs = api.userSteps.keywordsSteps().addDefaultKeywords(adGroupID, 2);
        firstKeywordID = keywordIDs.get(0);
        secondKeywordID = keywordIDs.get(1);
        api.userSteps.keywordsSteps().setKeywordStatus(adGroupID, firstKeywordID, StatusEnum.ACCEPTED);
        api.userSteps.keywordsSteps().setKeywordStatus(adGroupID, secondKeywordID, StatusEnum.ACCEPTED);

        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGet(new KeywordsSelectionCriteriaMap()
                .withIds(firstKeywordID, secondKeywordID));
        List<StateEnum> states = extract(keywords, on(KeywordGetItem.class).getState());
        assumeThat("оба ключевых слова включены", states, everyItem(equalTo(StateEnum.ON)));
    }

    @Test
    @Description("Два идентификатора в запросе: один продублированный, другой - нет")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3726")
    public void sameIdsInRequest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.SUSPEND,
                new SuspendRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(firstKeywordID, firstKeywordID, secondKeywordID)),
                ExpectedResult.warnings(firstKeywordID,
                        new Notification(10000, Api5ErrorDetails.KEYWORD_ID_DUPLICATED)),
                ExpectedResult.warnings(firstKeywordID,
                        new Notification(10000, Api5ErrorDetails.KEYWORD_ID_DUPLICATED)),
                ExpectedResult.success(secondKeywordID));

        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGet(new KeywordsSelectionCriteriaMap()
                .withIds(firstKeywordID, secondKeywordID));
        keywords = sort(keywords, on(KeywordGetItem.class).getId());
        assertThat("оба ключевых слова остановлены",
                keywords, beanEquivalent(Arrays.asList(
                        (KeywordGetItem) new KeywordGetItemMap()
                                .withId(firstKeywordID)
                                .withState(StateEnum.SUSPENDED).getBean(),
                        (KeywordGetItem) new KeywordGetItemMap()
                                .withId(secondKeywordID)
                                .withState(StateEnum.SUSPENDED).getBean())));
    }
}
