package ru.yandex.autotests.directapi.keywords.suspend;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordGetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.keywords.SuspendRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.on;
import static ch.lambdaj.Lambda.sort;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

@Aqua.Test
@Features(KeywordsFeatures.SUSPEND)
@Issue("https://st.yandex-team.ru/DIRECT-93825")
@Description("Одинаковые при нормализации слова в операции suspend")
public class SuspendSimilarKeywordsTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_SUSPEND;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private String firstKeyword = "autocad +2019 +купить +лицензию -цена";
    private String secondKeyword = "autocad 2019 +купить +лицензию -цена";
    private long firstKeywordID;
    private long secondKeywordID;

    @Before
    @Step("Подготовка данных для теста")
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
        firstKeywordID = api.userSteps.keywordsSteps().addKeyword(LOGIN, adGroupID, firstKeyword);
        secondKeywordID = api.userSteps.keywordsSteps().addKeyword(LOGIN, adGroupID, "куку");
        BidsRecord secondKeywordRecord = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(LOGIN)
                .bidsSteps()
                .getBidById(secondKeywordID);
        secondKeywordRecord.setPhrase(secondKeyword);
        secondKeywordRecord.setNormPhrase("2019 autocad купить лицензия");
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).bidsSteps().updateBids(secondKeywordRecord);
        api.userSteps.keywordsSteps().setKeywordStatus(adGroupID, firstKeywordID, StatusEnum.ACCEPTED);
        api.userSteps.keywordsSteps().setKeywordStatus(adGroupID, secondKeywordID, StatusEnum.ACCEPTED);
    }

    @Test
    @Description("Два кейворда с одинаковой нормальной формой в операции suspend")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3726")
    public void sameNormedPhrasesInSuspendRequest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.SUSPEND,
                new SuspendRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(firstKeywordID, secondKeywordID)),
                ExpectedResult.success(firstKeywordID),
                ExpectedResult.success(secondKeywordID));

        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGet(new KeywordsSelectionCriteriaMap()
                .withIds(firstKeywordID, secondKeywordID));
        keywords = sort(keywords, on(KeywordGetItem.class).getId());
        assertThat("оба ключевых слова должны быть остановлены и не должны быть удалены",
                keywords, beanEquivalent(Arrays.asList(
                        (KeywordGetItem) new KeywordGetItemMap()
                                .withId(firstKeywordID)
                                .withState(StateEnum.SUSPENDED).getBean(),
                        (KeywordGetItem) new KeywordGetItemMap()
                                .withId(secondKeywordID)
                                .withState(StateEnum.SUSPENDED).getBean())));
    }
}
