package ru.yandex.autotests.directapi.keywords.suspend;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.keywords.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.SuspendRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 12.05.15.
 * https://st.yandex-team.ru/TESTIRT-4391
 */
@Aqua.Test
@Features(KeywordsFeatures.SUSPEND)
@Issue("https://st.yandex-team.ru/DIRECT-39271")
@Description("Запросы на остановку ключевых слов через протокол SOAP")
public class SuspendSoapTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_SUSPEND;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN).protocol(ProtocolType.SOAP);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Запрос без поля SelectionCriteria в запросе на отключение ключевых слов")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3728")
    public void requestWithoutSelectionCriteria() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.SUSPEND,
                new SuspendRequestMap()
                        .withSelectionCriteria(null),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(DeleteRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @Issue("DIRECT-88268")
    @Description("Запрос без поля SelectionCriteria.Ids в запросе на отключение ключевых слов")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3727")
    public void requestWithoutIds() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.SUSPEND,
                new SuspendRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(DeleteRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @Description("Валидный запрос на остановку ключевых слов")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3729")
    public void correctRequest() {
        api.protocol(ProtocolType.JSON);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        long keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupID);

        api.protocol(ProtocolType.SOAP);
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.SUSPEND,
                new SuspendRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(keywordID)),
                ExpectedResult.success(keywordID));
    }
}
