package ru.yandex.autotests.directapi.keywords.suspend;

import java.util.List;

import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.SuspendRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 3/5/15.
 * https://st.yandex-team.ru/TESTIRT-4390
 */
@Aqua.Test
@Features(KeywordsFeatures.SUSPEND)
@Issue("https://st.yandex-team.ru/DIRECT-39271")
@Description("Остановка ключевого слова и автотаргетинга, которые уже остановлены")
@Tag(TagDictionary.TRUNK)
public class SuspendSuspendedKeywordAndAutotargetingTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_SUSPEND;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN).protocol(ProtocolType.JSON);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adGroupId;

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void prepareAdGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
    }

    @Test
    @Description("Попытка остановить ключевое слово, которое уже остановлено должна порождать ошибку")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3730")
    public void suspendSuspendedKeyword() {
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        api.userSteps.keywordsSteps().setKeywordStatus(adGroupId, keywordId, StatusEnum.ACCEPTED);

        api.userSteps.keywordsSteps().setKeywordStatus(adGroupId, keywordId, StatusEnum.ACCEPTED);
        api.userSteps.keywordsSteps().keywordsSuspend(keywordId);
        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGetById(keywordId);
        List<StateEnum> states = extract(keywords, on(KeywordGetItem.class).getState());
        assumeThat("ключевое слово находится в статусе Suspended", states, contains(StateEnum.SUSPENDED));
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.SUSPEND,
                new SuspendRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(keywordId)),
                ExpectedResult.warnings(new Notification(10240)));
    }

    @Test
    @Description("Попытка приостановить автотаргетинг, который уже приостановлен, должна порождать предупреждение")
    public void suspendSuspendedAutotargeting() {
        Long autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
        api.userSteps.keywordsSteps().keywordsSuspend(autotargetingId);
        assumeThat("автотаргетинг находится в статусе Suspended",
                api.userSteps.keywordsSteps().getKeywordState(autotargetingId),
                equalTo(StateEnum.SUSPENDED)
        );
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.SUSPEND,
                new SuspendRequestMap().withSelectionCriteria(
                        new IdsCriteriaMap().withIds(autotargetingId)
                ),
                ExpectedResult.warnings(new Notification(10244))
        );
    }
}
