package ru.yandex.autotests.directapi.keywords.update;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsBaseRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by gerdler on 17.04.17.
 * https://st.yandex-team.ru/DIRECT-64666
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Description("Проверка данных объектов в БД после обновления автотаргетинга")
@RunWith(Parameterized.class)
public class UpdateAutotargetingAndCheckDBTest {

    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT_UPDATE;
    private static final Timestamp YESTERDAY = Timestamp.from(Instant.now().minus(1, ChronoUnit.DAYS).truncatedTo(ChronoUnit.SECONDS));

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String oldUserParam1;

    @Parameterized.Parameter(value = 1)
    public String newUserParam1;

    @Parameterized.Parameter(value = 2)
    public String oldUserParam2;

    @Parameterized.Parameter(value = 3)
    public String newUserParam2;

    @Parameterized.Parameter(value = 4)
    public PhrasesStatusbssynced expectedAdGroupStatusBsSynced;

    @Parameterized.Parameters(name = "oldUserParam1 = {0}, newUserParam1 = {1}, oldUserParam2 = {2}, newUserParam2 = {3}")
    public static Collection fields() {
        Object[][] data = new Object[][]{
                {"param1", "newParam1", "param2", "param2", PhrasesStatusbssynced.No},
                {"param1", "param1", "param2", "newParam2", PhrasesStatusbssynced.No},
                {"param1", "newParam1", "param2", "newParam2", PhrasesStatusbssynced.No},
                {"param1", "param1", "param2", "param2", PhrasesStatusbssynced.Yes}
        };
        return Arrays.asList(data);
    }


    private static Long campaignId;
    private Long adGroupId;
    private Long autotargetingId;
    private Long adId;

    private static DirectJooqDbSteps dbSteps;
    private CampaignsRecord campaignsRecord;
    private PhrasesRecord phrasesRecord;
    private BidsBaseRecord bidsBaseRecord;
    private BannersRecord bannersRecord;

    @BeforeClass
    public static void prepareKeyword() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);
    }

    @Step("подготовка данных для теста")
    @Before
    public void prepareData() {
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        autotargetingId = api.userSteps.keywordsSteps().keywordsAdd(
                new KeywordAddMap()
                        .autotargeting(adGroupId)
                        .withUserParam1(oldUserParam1)
                        .withUserParam2(oldUserParam2)
        ).get(0);
        campaignsRecord = dbSteps.campaignsSteps().getCampaignById(campaignId);
        dbSteps.campaignsSteps().updateCampaigns(
                campaignsRecord.setStatusbssynced(CampaignsStatusbssynced.Yes).setLastchange(YESTERDAY)
        );

        phrasesRecord = dbSteps.adGroupsSteps().getPhrases(adGroupId);
        dbSteps.adGroupsSteps().updatePhrases(
                phrasesRecord.setStatusbssynced(PhrasesStatusbssynced.Yes).setLastchange(YESTERDAY)
                        .setStatusmoderate(PhrasesStatusmoderate.Yes)
        );

        bannersRecord = dbSteps.bannersSteps().getBanner(adId);
        dbSteps.bannersSteps().updateBanners(
                bannersRecord.setStatusbssynced(BannersStatusbssynced.Yes).setLastchange(YESTERDAY)
        );

        bidsBaseRecord = dbSteps.bidsBaseSteps().getBidsBaseByBidId(autotargetingId);
        dbSteps.bidsBaseSteps().updateBidsBase(
                bidsBaseRecord.setLastchange(YESTERDAY)
        );

        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(
                        new KeywordUpdateMap()
                                .withId(autotargetingId)
                                .withUserParam1(newUserParam1)
                                .withUserParam2(newUserParam2)
                ),
                ExpectedResult.success()
        );
    }

    @Test
    public void checkCampaignsRecord() {
        assertThat("у кампании правильные данные в БД",
                dbSteps.campaignsSteps().getCampaignById(campaignId),
                equalTo(campaignsRecord)
        );
    }

    @Test
    public void checkAdGroupsRecord() {
        PhrasesRecord phrasesRecordAfterUpdate = dbSteps.adGroupsSteps().getPhrases(adGroupId);
        if (expectedAdGroupStatusBsSynced == PhrasesStatusbssynced.No) {
            assertThat("у группы правильный statusBsSynced",
                    phrasesRecordAfterUpdate.getStatusbssynced(),
                    equalTo(expectedAdGroupStatusBsSynced)
            );
            phrasesRecord.setStatusbssynced(expectedAdGroupStatusBsSynced);

            Timestamp lastChangeAfterUpdate = phrasesRecordAfterUpdate.getLastchange();
            assertThat("у группы поменялся LastChange",
                    lastChangeAfterUpdate,
                    greaterThan(YESTERDAY)
            );
            phrasesRecord.setLastchange(lastChangeAfterUpdate);
        }

        assertThat("у группы правильные данные в БД",
                phrasesRecordAfterUpdate,
                equalTo(phrasesRecord)
        );
    }

    @Test
    public void checkAdsRecord() {
        assertThat("у объявления данные не изменились",
                dbSteps.bannersSteps().getBanner(adId),
                equalTo(bannersRecord)
        );
    }

    @Test
    public void checkAutotargetingRecord() {
        BidsBaseRecord bidsBaseRecordAfterUpdate = dbSteps.bidsBaseSteps().getBidsBaseByBidId(autotargetingId);
        if (expectedAdGroupStatusBsSynced == PhrasesStatusbssynced.No) {
            Timestamp lastChangeAfterUpdate = bidsBaseRecordAfterUpdate.getLastchange();
            assertThat("у автотаргетинга поменялся LastChange",
                    lastChangeAfterUpdate,
                    greaterThan(YESTERDAY)
            );
            bidsBaseRecord.setLastchange(lastChangeAfterUpdate);
        }

        assertThat("у автотаргетинга правильные данные в БД",
                bidsBaseRecordAfterUpdate,
                equalTo(bidsBaseRecord)
        );
    }
}
