package ru.yandex.autotests.directapi.keywords.update;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

/**
 * Created by gerdler on 17.04.17.
 * https://st.yandex-team.ru/DIRECT-64666
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-64386")
@Description("Негативные сценарии обновления автотаргетинга")
public class UpdateAutotargetingNegativeTest {

    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT_UPDATE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    private static Long campaignId;
    private Long autotargetingId;

    @BeforeClass
    public static void prepareCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
    }

    @Before
    public void prepareAutotargeting() {
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
    }

    @Test
    @Description("Проверяем получение ошибки при попытке обновить текст автотаргетинга")
    public void updateAutotargetingTextTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(
                        new KeywordUpdateMap().withId(autotargetingId).withKeyword("фраза")
                ),
                ExpectedResult.success() // возможно поведение будет изменено в https://st.yandex-team.ru/DIRECT-65906
        );
    }

    @Test
    @Description("Проверяем получение ошибки при попытке обновить удаленный автотаргетинг")
    public void updateDeletedAutotargetingTest() {
        api.userSteps.keywordsSteps().keywordsDelete(autotargetingId);
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(
                        new KeywordUpdateMap().withId(autotargetingId).withUserParam1("user_param_1")
                ),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.KEYWORD_NOT_FOUND))
        );
    }
}
