package ru.yandex.autotests.directapi.keywords.update;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

/**
 * Created by gerdler on 17.04.17.
 * https://st.yandex-team.ru/DIRECT-64666
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-64386")
@Description("Позитивные сценарии обновления автотаргетинга")
public class UpdateAutotargetingPositiveTest {

    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT_UPDATE;
    private static final String PARAM1 = "new param1";
    private static final String PARAM2 = "new param2";

    private static Long campaignId;
    private Long autotargetingId;
    private Long bannerId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
    }

    @Before
    public void init() {
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        bannerId = api.userSteps.adsSteps().addDefaultMobileAppAd(adGroupId);
        autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
    }

    @Test
    @Description("Только обязательные поля в запросе на обновление автотаргетинга")
    public void updateOnlyRequiredFieldsTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(
                        new KeywordUpdateMap().withId(autotargetingId)
                ),
                ExpectedResult.success(autotargetingId)
        );
    }

    @Test
    @Description("Все поля в запросе на обновление ключевого слова")
    public void updateAllKeywordFieldsTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(
                        new KeywordUpdateMap()
                                .withId(autotargetingId)
                                .withUserParam1(PARAM1)
                                .withUserParam2(PARAM2)
                ),
                ExpectedResult.success(autotargetingId)
        );
    }

    @Test
    public void updateAutotargetingInArchivedAdGroupTest() {
        api.userSteps.bannersFakeSteps().makeBannersModerated(bannerId);
        api.userSteps.adsSteps().adsArchive(bannerId);

        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(
                        new KeywordUpdateMap().withId(autotargetingId)
                ),
                ExpectedResult.success(autotargetingId)
        );
    }
}
