package ru.yandex.autotests.directapi.keywords.update;


import java.nio.charset.Charset;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by gerdler on 17.04.2017.
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Description("Проверка допустимых значений параметров UserParam1 и UserParam2 для автотаргетинга, негативные сценарии")
public class UpdateAutotargetingUserParamNegativeTest {
    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long campaignId;
    private KeywordUpdateMap keywordUpdateMap;

    @BeforeClass
    public static void prepareCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
    }

    @Before
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
        keywordUpdateMap = new KeywordUpdateMap().withId(autotargetingId);
    }

    @Test
    public void userParam1MoreThanMaxLenUpdateTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(
                        keywordUpdateMap.withUserParam1(
                                RandomStringUtils.randomAlphabetic(KeywordAddMap.MAX_USER_PARAM_LENGTH + 1)
                        )
                ),
                JavaOrPerlExpectedResult.java(
                        ExpectedResult.errors(
                                new Notification(5001, Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                                        path(KeywordAddMap.USER_PARAM_1), 255))
                ).perl(
                        ExpectedResult.errors(
                                new Notification(5001, Api5ErrorDetails.FIELD_VALUE_SHOULD_NOT_BE_MORE_THAN,
                                        path(KeywordAddMap.USER_PARAM_1), 255))
                )
        );
    }

    @Test
    public void userParam2MoreThanMaxLenUpdateTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(
                        keywordUpdateMap.withUserParam2(
                                RandomStringUtils.randomAlphabetic(KeywordAddMap.MAX_USER_PARAM_LENGTH + 1)
                        )
                ),
                JavaOrPerlExpectedResult.java(
                        ExpectedResult.errors(
                                new Notification(5001, Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                                        path(KeywordAddMap.USER_PARAM_2), 255))
                ).perl(
                        ExpectedResult.errors(
                                new Notification(5001, Api5ErrorDetails.FIELD_VALUE_SHOULD_NOT_BE_MORE_THAN,
                                        path(KeywordAddMap.USER_PARAM_2), 255))
                )
        );
    }

    @Test
    public void userParam1WrongEncodingUpdateTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(
                        keywordUpdateMap.withUserParam1(
                                new String("Параметр".getBytes(Charset.forName("UTF-8")), Charset.forName("cp1251"))
                        )
                ),
                JavaOrPerlExpectedResult.java(
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetailsJava.USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD_EN,
                                path(KeywordAddMap.USER_PARAM_1))))
                        .perl(ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetails.USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD_EN,
                                path(KeywordAddMap.USER_PARAM_1))))
        );
    }

    @Test
    public void userParam2WrongEncodingUpdateTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(
                        keywordUpdateMap.withUserParam2(
                                new String("Параметр".getBytes(Charset.forName("UTF-8")), Charset.forName("cp1251"))
                        )
                ),
                JavaOrPerlExpectedResult.java(
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetailsJava.USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD_EN,
                                path(KeywordAddMap.USER_PARAM_2))))
                        .perl(ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetails.USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD_EN,
                                path(KeywordAddMap.USER_PARAM_2))))
        );
    }
}
