package ru.yandex.autotests.directapi.keywords.update;


import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by gerdler on 17.04.2017.
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Description("Проверка допустимых значений параметров UserParam1 и UserParam2 для автотаргетинга, позитивные сценарии")
@RunWith(Parameterized.class)
public class UpdateAutotargetingUserParamPositiveTest {
    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String userParam;

    @Parameterized.Parameters(name = "value = {0}")
    public static Collection fieldsValue() throws UnsupportedEncodingException {
        Object[][] data = new Object[][]{
                {"Пустая строка", ""},
                {"Строка из пробелов", "  "},
                {"Латинские символы", RandomStringUtils.randomAlphabetic(10)},
                {"Цифровые символы", RandomStringUtils.randomAlphabetic(10)},
                {"Латинские и цифровые символы", RandomStringUtils.randomAlphanumeric(10)},
                {"Кириллические символы", "параметр"},
                {"Турецкие символы", "türkçe"},
                {"Спецсимволы", "param/param?key=1"},
                {"Строка с пробелом", RandomStringUtils.randomAlphabetic(5) + "  " + RandomStringUtils.randomAlphabetic(5)},
                {"Минимальная длина", RandomStringUtils.randomAlphabetic(1)},
                {"Максимальная длина", RandomStringUtils.randomAlphabetic(KeywordAddMap.MAX_USER_PARAM_LENGTH)}
        };
        return Arrays.asList(data);
    }

    private static Long campaignId;
    private KeywordUpdateMap keywordUpdateMap;

    @BeforeClass
    public static void prepareCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
    }

    @Before
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
        keywordUpdateMap = new KeywordUpdateMap().withId(autotargetingId);
    }

    @Test
    public void userParam1UpdateTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(keywordUpdateMap.withUserParam1(userParam)),
                ExpectedResult.success()
        );
    }

    @Test
    public void userParam2UpdateTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(keywordUpdateMap.withUserParam2(userParam)),
                ExpectedResult.success()
        );
    }
}
