package ru.yandex.autotests.directapi.keywords.update;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 26.02.16.
 * https://st.yandex-team.ru/TESTIRT-8627
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Issues({
        @Issue("https://st.yandex-team.ru/DIRECT-51201"),
        @Issue("https://st.yandex-team.ru/DIRECT-51364")
})
@Description("Проверка StatusBsSynced группы после обновления фразы")
@RunWith(Parameterized.class)
public class UpdateKeywordAndCheckAdGroupStatusBsSynced {

    private static final String client = KeywordsLogins.SINGLE_CLIENT_UPDATE;

    private static Long campaignId;

    private Long adGroupId;
    private Long keywordId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String oldKeyword;

    @Parameterized.Parameter(value = 1)
    public String newKeyword;

    @Parameterized.Parameters(name = "oldKeyword = {0}, newKeyword = {1}")
    public static Collection fields() {
        Object[][] data = new Object[][]{
                {"слово", "слово -минус"},
                {"слово за слово", "слово +за слово"},
                {"слово", "!слово"}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareKeyword() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Step("подготовка данных для теста")
    @Before
    public void prepareData() {
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        keywordId = api.userSteps.keywordsSteps().addKeyword(adGroupId, oldKeyword);

        DirectJooqDbSteps directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(client);

        api.userSteps.bannersFakeSteps().makeBannersActiveAndFullyModerated(adId);
        directJooqDbSteps.adGroupsSteps().makePhraseModeratedAndBsSynced(adGroupId);
        api.userSteps.campaignFakeSteps().makeCampaignActive(campaignId);

        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap()
                        .withKeywords(new KeywordUpdateMap()
                                .withId(keywordId)
                                .withKeyword(newKeyword)),
                ExpectedResult.success());
    }

    @Test
    public void checkAdGroupStatusBsSynced() {
        GroupFakeInfo groupInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assertThat("у группы верный StatusBsSynced",
                groupInfo.getStatusBsSynced(), equalTo(Status.NO));
    }
}
