package ru.yandex.autotests.directapi.keywords.update;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsRecord;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerPhraseFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 26.02.16.
 * https://st.yandex-team.ru/TESTIRT-8627
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-51364")
@Description("Проверка статусов модерации группы после обновления фразы")
@RunWith(Parameterized.class)
public class UpdateKeywordAndCheckAdGroupStatusesModerate {

    private static final String client = KeywordsLogins.SINGLE_CLIENT_UPDATE;

    private static final String OLD_KEYWORD = "слово";
    private static final String NEW_KEYWORD = "слово воробей -вылетит";

    private static Long campaignId;
    private static int shard;

    private Long adGroupId;
    private Long keywordId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String adGroupStatusModerate;

    @Parameterized.Parameter(value = 1)
    public String adGroupStatusPostModerate;

    @Parameterized.Parameter(value = 2)
    public String keywordStatusModerate;

    @Parameterized.Parameter(value = 3)
    public String expectedAdGroupStatusModerate;

    @Parameterized.Parameter(value = 4)
    public String expectedAdGroupStatusPostModerate;

    @Parameterized.Parameter(value = 5)
    public String expectedKeywordStatusModerate;

    @Parameterized.Parameters(name = "adGroupStatusModerate = {0}, adGroupStatusPostModerate = {1}, " +
            "keywordStatusModerate = {2}")
    public static Collection fields() {
        Object[][] data = new Object[][]{
                {Status.YES, Status.YES, Status.YES, Status.READY, Status.NO, Status.NEW},
                {Status.YES, Status.YES, Status.NO, Status.READY, Status.NO, Status.NEW},
                {Status.YES, Status.NO, Status.YES, Status.READY, Status.NO, Status.NEW},
                {Status.YES, Status.NO, Status.NO, Status.READY, Status.NO, Status.NEW},
                {Status.YES, Status.REJECTED, Status.YES, Status.READY, Status.REJECTED, Status.NEW},
                {Status.YES, Status.REJECTED, Status.NO, Status.READY, Status.REJECTED, Status.NEW},
                {Status.NO, Status.YES, Status.YES, Status.READY, Status.NO, Status.NEW},
                {Status.NO, Status.YES, Status.NO, Status.READY, Status.NO, Status.NEW},
                {Status.NO, Status.NO, Status.YES, Status.READY, Status.NO, Status.NEW},
                {Status.NO, Status.NO, Status.NO, Status.READY, Status.NO, Status.NEW},
                {Status.NO, Status.REJECTED, Status.YES, Status.READY, Status.REJECTED, Status.NEW},
                {Status.NO, Status.REJECTED, Status.NO, Status.READY, Status.REJECTED, Status.NEW},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareKeyword() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        shard = api.userSteps.clientFakeSteps().getUserShard(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Step("подготовка данных для теста")
    @Before()
    public void prepareData() {
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        keywordId = api.userSteps.keywordsSteps().addKeyword(adGroupId, OLD_KEYWORD);
        api.userSteps.groupFakeSteps().setStatusModerate(adGroupId, adGroupStatusModerate);
        api.userSteps.groupFakeSteps().setStatusPostModerate(adGroupId, adGroupStatusPostModerate);
        BidsRecord bids = api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsSteps().getBidById(keywordId);
        bids.setStatusmoderate(BidsStatusmoderate.valueOf(keywordStatusModerate));
        api.userSteps.getDirectJooqDbSteps().bidsSteps().updateBids(bids);
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap()
                        .withKeywords(new KeywordUpdateMap()
                                .withId(keywordId)
                                .withKeyword(NEW_KEYWORD)),
                ExpectedResult.success());
    }

    @Test
    public void checkAdGroupStatusModerate() {
        GroupFakeInfo groupInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assertThat("у группы верный статус модерации",
                groupInfo.getStatusModerate(), equalTo(expectedAdGroupStatusModerate));
    }

    @Test
    public void checkAdGroupStatusPostModerate() {
        GroupFakeInfo groupInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assertThat("у группы верный статус постмодерации",
                groupInfo.getStatusPostModerate(), equalTo(expectedAdGroupStatusPostModerate));
    }

    @Test
    public void checkKeywordStatusModerate() {
        BannerPhraseFakeInfo bannerPhraseFakeInfo = api.userSteps.phrasesFakeSteps().getBannerPhraseParams(keywordId);
        assertThat("у фразы верный статус модерации",
                bannerPhraseFakeInfo.getStatusModerate(), equalTo(expectedKeywordStatusModerate));
    }
}
