package ru.yandex.autotests.directapi.keywords.update;


import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 31.01.17.
 * https://st.yandex-team.ru/TESTIRT-10965
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-62314")
@Description("Проверка статусов модерации объявления после обновления фразы")
public class UpdateKeywordAndCheckMobileAdStatusModerate {
    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_UPDATE;
    private static final String OLD_KEYWORD = "слово";
    private static final String NEW_KEYWORD = "слово +новое";
    private static final String NEW_KEYWORD_WITH_MINUSWORD = "слово -минус";
    private static final String TEXT_WITH_TEMPLATE = "текст с #шаблоном#";
    private static Long mobileCampaignId;
    private BannerFakeInfo adInfo;
    private Long adId;
    private Long keywordId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void addCampaign() {
        mobileCampaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign(LOGIN);
    }

    @Before()
    public void prepareData() {
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(mobileCampaignId);
        adId = api.userSteps.adsSteps().addDefaultMobileAppAd(adGroupId);
        keywordId = api.userSteps.keywordsSteps().addKeyword(adGroupId, OLD_KEYWORD);
        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                    new ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap().withAds(
                            new AdUpdateItemMap()
                                    .withId(adId)
                                    .withMobileAppAd(new MobileAppAdUpdateMap().withText(TEXT_WITH_TEMPLATE))
                    ),
                    ExpectedResult.success(adId));
        api.userSteps.groupFakeSteps().setStatusModerate(adGroupId, Status.YES);
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.YES);
        api.userSteps.phrasesFakeSteps().setPhraseStatusModerateYes(adGroupId);
    }

    @Test
    public void updateKeyword() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap()
                        .withKeywords(new KeywordUpdateMap()
                                .withId(keywordId)
                                .withKeyword(NEW_KEYWORD)),
                ExpectedResult.success());
        adInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assertThat("у объявления изменился статус модерации", adInfo.getStatusModerate(), equalTo(Status.READY));
    }

    @Test
    public void updateKeywordWithMinusWord() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap()
                        .withKeywords(new KeywordUpdateMap()
                                .withId(keywordId)
                                .withKeyword(NEW_KEYWORD_WITH_MINUSWORD)),
                ExpectedResult.success());
        adInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assertThat("у объявления не изменился статус модерации", adInfo.getStatusModerate(), equalTo(Status.YES));
    }
}


