package ru.yandex.autotests.directapi.keywords.update;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;

/**
 * Created by semkagtn on 30.04.15.
 * https://st.yandex-team.ru/TESTIRT-4580
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-36383")
@Description("Обновление ключевых слов группе, находящейся в различных статусах")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateKeywordsAdGroupStatusesTest {

    private static final String client = KeywordsLogins.SINGLE_CLIENT_UPDATE;

    private static Long campaignID;
    private long keywordID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String statusModerate;

    @Parameterized.Parameter(2)
    public String statusPostModerate;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Обновить ключевое слово из группы-черновика",
                        Status.NEW, Status.NO},
                {"Обновить ключевое слово из группы, которая находится на модерации",
                        Status.SENDING, Status.NO},
                {"Обновить ключевое слово из группы, которая предварительно принята на модерации",
                        Status.YES, Status.NO},
                {"Обновить ключевое слово из группы, которая принята на модерации",
                        Status.YES, Status.YES},
                {"Обновить ключевое слово из группы, которая отклонена на модерации",
                        Status.NO, Status.YES},
        });
    }

    @BeforeClass
    public static void prepareCampaign() {
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createKeyword() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(groupID);
        api.userSteps.groupFakeSteps().setStatusModerate(groupID, statusModerate);
        api.userSteps.groupFakeSteps().setStatusPostModerate(groupID, statusPostModerate);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3748")
    public void updateKeywordFromGroupWithStatus() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(new KeywordUpdateMap()
                        .withId(keywordID)),
                ExpectedResult.success());
    }


}
