package ru.yandex.autotests.directapi.keywords.update;

import java.util.List;

import com.yandex.direct.api.v5.general.PriorityEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Bids;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsHrefParamsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 28.09.16.
 * https://st.yandex-team.ru/TESTIRT-10266
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Description("Обновление ключевых слов и проверка их состояния в базе")
@Issue("https://st.yandex-team.ru/DIRECT-58442")
public class UpdateKeywordsAndCheckDBTest {
    private static Long keywordId;
    private static BidsRecord bidsBeforeUpdate;
    private static BidsHrefParamsRecord bidsHrefParamsBeforeUpdate;
    private static BidsRecord bidsAfterUpdate;
    private static BidsHrefParamsRecord bidsHrefParamsAfterUpdate;

    private static final String PHRASE_BEFORE_UPDATE = "phrase";
    private static final String PHRASE_AFTER_UPDATE = "phrase -minusWord";
    private static final long CONTEXT_BID = 200_000_000L;
    private static final long BID = 300_000_000L;
    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT_UPDATE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static DirectJooqDbSteps directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);

    @BeforeClass
    public static void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        List<Long> keywords = api.userSteps.keywordsSteps().keywordsAdd(
                new KeywordAddMap()
                        .defaultKeyword()
                        .withKeyword(PHRASE_BEFORE_UPDATE)
                        .withAdGroupId(adGroupId)
                        .withStrategyPriority(PriorityEnum.HIGH)
                        .withContextBid(CONTEXT_BID)
                        .withBid(BID)
        );
        assumeThat("создалась одна фраза", keywords, hasSize(1));
        keywordId = keywords.get(0);
        bidsBeforeUpdate = directJooqDbSteps.bidsSteps().getBidByCid(campaignId);
        bidsHrefParamsBeforeUpdate = directJooqDbSteps.bidsSteps().getBidsHrefParamsByCid(campaignId);

        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap()
                        .withKeywords(new KeywordUpdateMap()
                                .withId(keywordId)
                                .withKeyword(PHRASE_AFTER_UPDATE)),
                ExpectedResult.success());

        bidsAfterUpdate = directJooqDbSteps.bidsSteps().getBidByCid(campaignId);
        bidsHrefParamsAfterUpdate = directJooqDbSteps.bidsSteps().getBidsHrefParamsByCid(campaignId);
    }


    @Test
    public void checkPpcBidsAfterUpdateKeyword() {
        assertThat("в ключевой фразе не изменилось ничего лишнего",
                bidsAfterUpdate.intoMap(), beanDiffer(bidsBeforeUpdate.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.allFieldsExcept(
                                BeanFieldPath.newPath(Bids.BIDS.MODTIME.getName()),
                                BeanFieldPath.newPath(Bids.BIDS.PHRASE.getName()),
                                // place может быть пересчитан при обновлении
                                BeanFieldPath.newPath(Bids.BIDS.PLACE.getName()),
                                // прогноз показов может быть пересчитан при обновлении
                                BeanFieldPath.newPath(Bids.BIDS.SHOWSFORECAST.getName())
                        )));
    }

    @Test
    public void checkPpcBidsHrefParamsAfterUpdateKeyword() {
        assertThat("в ключевой фразе не изменилось ничего лишнего",
                bidsHrefParamsAfterUpdate.intoMap(), beanDiffer(bidsHrefParamsBeforeUpdate.intoMap()));
    }
}
