package ru.yandex.autotests.directapi.keywords.update;

import java.util.List;

import com.yandex.direct.api.v5.general.PriorityEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordGetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 28.09.16.
 * https://st.yandex-team.ru/TESTIRT-10266
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Description("Обновление ключевых слов и проверка их в ответе метода Get")
@Issue("https://st.yandex-team.ru/DIRECT-58442")
public class UpdateKeywordsAndCheckGetResponseTest {
    private static Long keywordId;
    private static KeywordGetItem keywordsBeforeUpdate;
    private static KeywordGetItem keywordsAfterUpdate;

    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT_UPDATE;
    private static final String PHRASE_BEFORE_UPDATE = "phrase";
    private static final String PHRASE_AFTER_UPDATE = "phrase -minusWord";
    private static final long CONTEXT_BID = 200_000_000L;
    private static final long BID = 300_000_000L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void prepareData(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        List<Long> keywords = api.userSteps.keywordsSteps().keywordsAdd(
                new KeywordAddMap()
                        .defaultKeyword()
                        .withKeyword(PHRASE_BEFORE_UPDATE)
                        .withAdGroupId(adGroupId)
                        .withStrategyPriority(PriorityEnum.HIGH)
                        .withContextBid(CONTEXT_BID)
                        .withBid(BID)
        );
        assumeThat("создалась одна фраза", keywords, hasSize(1));
        keywordId = keywords.get(0);
        keywordsBeforeUpdate = api.userSteps.keywordsSteps().keywordsGetById(keywordId).get(0);

        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap()
                        .withKeywords(new KeywordUpdateMap()
                                .withId(keywordId)
                                .withKeyword(PHRASE_AFTER_UPDATE)),
                ExpectedResult.success());

        keywordsAfterUpdate = api.userSteps.keywordsSteps().keywordsGetById(keywordId).get(0);
    }

    @Test
    public void checkGetResponseAfterUpdateKeyword(){
        assertThat("в ключевой фразе не изменилось ничего лишнего",
                keywordsAfterUpdate, beanDiffer(keywordsBeforeUpdate)
                        .useCompareStrategy(DefaultCompareStrategies.allFieldsExcept(
                                BeanFieldPath.newPath(KeywordGetItemMap.KEYWORD)
                        )));
    }
}
