package ru.yandex.autotests.directapi.keywords.update;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;

/**
 * Created by semkagtn on 30.04.15.
 * https://st.yandex-team.ru/TESTIRT-4580
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-36383")
@Description("Попытка обновления ключевого слова менеджером или агентством в группе другого клиента")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateKeywordsAssistantAccessTest {

    private long keywordID;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String clientGroup;

    @Parameterized.Parameter(value = 2)
    public String clientKeyword;

    @Parameterized.Parameter(value = 3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "operator = {0}, group client = {1}, keyword client = {2}")
    public static Collection logins() {
        Object[][] data = new Object[][]{
                {KeywordsLogins.AGENCY_3, KeywordsLogins.SUBCLIENT_1, KeywordsLogins.SUBCLIENT_3,
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.KEYWORD_NOT_FOUND))},
                {Logins.MANAGER_DEFAULT, KeywordsLogins.SERV_CLIENT_1, KeywordsLogins.SERV_CLIENT_2,
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.KEYWORD_NOT_FOUND))}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareKeyword() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(operator);
        Long campaignID = api.as(operator).userSteps.campaignSteps().addDefaultTextCampaign(clientGroup);
        long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, clientGroup);
        keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(clientGroup, groupID);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3749")
    public void updateKeyword() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                clientKeyword,
                new UpdateRequestMap().withKeywords(new KeywordUpdateMap()
                        .withId(keywordID)),
                expectedResult);
    }
}
