package ru.yandex.autotests.directapi.keywords.update;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordGetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by semkagtn on 15.05.15.
 * https://st.yandex-team.ru/TESTIRT-4580
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-41390")
@Description("Обновить ключевое слово текстом существующего ключевого слова")
@Tag(TagDictionary.TRUNK)
public class UpdateKeywordsDuplicateKeywordTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_UPDATE;

    private static final String KEYWORD1 = "Номер один";
    private static final String KEYWORD2 = "Номер два";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    private static Long campaignId;

    private long adGroupId;
    private long anotherAdGroupId;
    private long keywordId1;
    private long keywordId2;
    private long anotherKeywordId;

    @BeforeClass
    public static void prepareCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareKeywords(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        keywordId1 = api.userSteps.keywordsSteps().addKeyword(adGroupId, KEYWORD1);
        keywordId2 = api.userSteps.keywordsSteps().addKeyword(adGroupId, KEYWORD2);

        anotherAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        anotherKeywordId = api.userSteps.keywordsSteps().addKeyword(anotherAdGroupId, KEYWORD1);
    }

    @Test
    @Description("Проверка того, что вернётся идентификатор второго ключевого слова")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3754")
    public void checkReturningId() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap()
                        .withKeywords(new KeywordUpdateMap()
                                .withId(keywordId1)
                                .withKeyword(KEYWORD2)),
                ExpectedResult.warnings(keywordId2, new Notification(10140)));
    }

    @Test
    @Description("Проверка того, что первое ключевое слово было удалено")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3755")
    public void checkIfFirstKeywordDeleted() {
        api.userSteps.keywordsSteps().keywordsUpdate(new KeywordUpdateMap()
                .withId(keywordId1)
                .withKeyword(KEYWORD2));

        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGet(new KeywordsSelectionCriteriaMap()
                .withAdGroupIds(adGroupId));
        assertThat("в группе осталось только второе ключевое слово", keywords, beanEquivalent(Arrays.asList(
                (KeywordGetItem) new KeywordGetItemMap()
                        .withId(keywordId2).getBean())));
    }

    @Test
    @Description("Проверка того, что не происходит сравнения ключевых слов из разных групп")
    public void checkSameKeywordsInDifferentAdGroups() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap()
                        .withKeywords(
                                new KeywordUpdateMap().withId(keywordId1).withKeyword(KEYWORD1),
                                new KeywordUpdateMap().withId(anotherKeywordId).withKeyword(KEYWORD1)
                        ),
                ExpectedResult.success(), ExpectedResult.success()
        );
    }
}
