package ru.yandex.autotests.directapi.keywords.update;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by semkagtn on 30.04.15.
 * https://st.yandex-team.ru/TESTIRT-4580
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-36383")
@Description("Неверный тип полей в запросе на обновление ключевых слов")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateKeywordsFieldTypesNegativeTest {
    private static final String SINGLE_CLIENT = KeywordsLogins.SINGLE_CLIENT_UPDATE;

    private static long keywordId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SINGLE_CLIENT).protocol(ProtocolType.JSON);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter()
    public String description;

    @Parameterized.Parameter(value = 1)
    public String fieldName;

    @Parameterized.Parameter(value = 2)
    public Object fieldValue;

    @Parameterized.Parameter(value = 3)
    public Api5Error perlError;

    // Ошибка для Java сервиса
    @Parameterized.Parameter(value = 4)
    public Api5Error javaError;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection fields() {
        Object[][] data = new Object[][]{
                {"Вещественное число в поле Id", KeywordUpdateMap.ID, 2.13f,
                        new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                                path(KeywordUpdateMap.ID)),
                        new Api5Error(8000, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD2,
                                path(UpdateRequestMap.KEYWORDS, KeywordUpdateMap.ID)),
                },
                {"Объект в поле Id", KeywordUpdateMap.ID, new JSONObject(),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                                StringUtils.capitalize(KeywordUpdateMap.ID)),
                        new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                                path(UpdateRequestMap.KEYWORDS, KeywordUpdateMap.ID)),
                },
                {"Объект в поле UserParam1", KeywordUpdateMap.USER_PARAM_1, new JSONObject(),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_STRING,
                                path(KeywordAddMap.USER_PARAM_1)),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_STRING,
                                path(UpdateRequestMap.KEYWORDS, KeywordAddMap.USER_PARAM_1)),
                },
                {"Массив в поле UserParam1", KeywordUpdateMap.USER_PARAM_1, singletonList("Россия"),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                path(KeywordAddMap.USER_PARAM_1)),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                path(UpdateRequestMap.KEYWORDS, KeywordAddMap.USER_PARAM_1)),
                },
                {"Объект в поле UserParam2", KeywordUpdateMap.USER_PARAM_2, new JSONObject(),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_STRING,
                                path(KeywordAddMap.USER_PARAM_2)),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_STRING,
                                path(UpdateRequestMap.KEYWORDS, KeywordAddMap.USER_PARAM_2)),
                },
                {"Массив в поле UserParam2", KeywordUpdateMap.USER_PARAM_2, singletonList("Россия"),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                path(KeywordAddMap.USER_PARAM_2)),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                path(UpdateRequestMap.KEYWORDS, KeywordAddMap.USER_PARAM_2)),
                },
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareKeyword() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SINGLE_CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(SINGLE_CLIENT);
        long groupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(groupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3756")
    public void invalidRequiredFieldTypeTest() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorJsonOn(
                Action.UPDATE,
                createRequest(),
                JavaOrPerlApi5Error.java(javaError).perl(perlError)
        );
    }

    @SuppressWarnings("unchecked")
    private JSONObject createRequest() {
        JSONObject keyword = new JSONObject();
        keyword.put(StringUtils.capitalize(KeywordUpdateMap.ID), keywordId);
        keyword.put(StringUtils.capitalize(fieldName), fieldValue);

        JSONObject request = new JSONObject();
        request.put(StringUtils.capitalize(UpdateRequestMap.KEYWORDS), singletonList(keyword));
        return request;
    }
}
