package ru.yandex.autotests.directapi.keywords.update;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by semkagtn on 07.05.15.
 * https://st.yandex-team.ru/TESTIRT-4580
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-36383")
@Description("Проверка недопустимых значений параметра KeywordId")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateKeywordsKeywordIdNegativeTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_UPDATE;
    private static final String ANOTHER_LOGIN = KeywordsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter()
    public String description;

    @Parameterized.Parameter(1)
    public long invalidKeywordId;

    @Parameterized.Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(ANOTHER_LOGIN);

        api.as(ANOTHER_LOGIN);
        Long anotherCampaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(ANOTHER_LOGIN);
        long anotherAdGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(anotherCampaignID);
        long anotherKeywordID = api.userSteps.keywordsSteps().addDefaultKeyword(anotherAdGroupID);

        api.as(LOGIN);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        long deletedKeywordID = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupID);
        api.userSteps.keywordsSteps().keywordsDelete(deletedKeywordID);
        long nonexistentKeywordID = deletedKeywordID + 700000L;

        return Arrays.asList(new Object[][]{
                {"нулевой идентификатор ключевого слова", 0,
                        JavaOrPerlExpectedResult.java(
                                ExpectedResult.errors(
                                        new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                                                path(KeywordUpdateMap.ID)))
                        ).perl(
                                ExpectedResult.errors(
                                        new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                                path(KeywordUpdateMap.ID)))
                        )
                },
                {"отрицательный идентификатор ключевого слова", -1,
                        JavaOrPerlExpectedResult.java(
                                ExpectedResult.errors(
                                        new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                                                path(KeywordUpdateMap.ID)))
                        ).perl(
                                ExpectedResult.errors(
                                        new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                                path(KeywordUpdateMap.ID)))
                        )
                },
                {"несуществующий идентификатор ключевого слова", nonexistentKeywordID,
                        JavaOrPerlExpectedResult.both(
                                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.KEYWORD_NOT_FOUND)))
                },
                {"удаленный идентификатор ключевого слова", deletedKeywordID,
                        JavaOrPerlExpectedResult.both(
                                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.KEYWORD_NOT_FOUND)))
                },
                {"чужой идентификатор ключевого слова", anotherKeywordID,
                        JavaOrPerlExpectedResult.both(
                                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.KEYWORD_NOT_FOUND)))
                },
        });
    }

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3757")
    public void updateInvalidKeywordId() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(new KeywordUpdateMap()
                        .withId(invalidKeywordId)),
                expectedResult);
    }
}
