package ru.yandex.autotests.directapi.keywords.update;

import java.util.List;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static org.hamcrest.Matchers.contains;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Description("Проверка на отсутствие переминусовки ключевых фраз")
@Issue("https://st.yandex-team.ru/DIRECT-41661")
public class UpdateKeywordsMinusUnglueTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_UPDATE;
    private static final String KEYWORD1 = "слово1";
    private static final String KEYWORD2 = "слово2";
    private static final String KEYWORD1_UPDATE = "слово1 слово2";
    private static final String KEYWORD2_UPDATE = "слово1 слово2 слово3";

    private Long keywordId1;
    private Long keywordId2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @Before
    public void before() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        List<Long> keywordIds = api.userSteps.keywordsSteps().keywordsAdd(
                new KeywordAddMap()
                        .withAdGroupId(adGroupId)
                        .withKeyword(KEYWORD1),
                new KeywordAddMap()
                        .withAdGroupId(adGroupId)
                        .withKeyword(KEYWORD2));
        keywordId1 = keywordIds.get(0);
        keywordId2 = keywordIds.get(1);
    }

    @Test
    public void keywordAfterUpdateOneMustBeWithoutExtraMinusWords() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(
                        new KeywordUpdateMap()
                                .withId(keywordId1)
                                .withKeyword(KEYWORD1_UPDATE)),
                ExpectedResult.success(keywordId1)
        );
        List<KeywordGetItem> items = api.userSteps.keywordsSteps().keywordsGetById(keywordId1, keywordId2);
        List<String> keywords = items.stream().map(KeywordGetItem::getKeyword).collect(Collectors.toList());
        assertThat("Ключевые фразы соотвествуют ожиданиям",
                keywords, contains(KEYWORD1_UPDATE, KEYWORD2));
    }

    @Test
    public void keywordAfterUpdateTwoMustBeWithoutExtraMinusWords() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(
                        new KeywordUpdateMap()
                                .withId(keywordId1)
                                .withKeyword(KEYWORD1_UPDATE),
                        new KeywordUpdateMap()
                                .withId(keywordId2)
                                .withKeyword(KEYWORD2_UPDATE)),
                ExpectedResult.success(keywordId1),
                ExpectedResult.success(keywordId2)
        );
        List<KeywordGetItem> items = api.userSteps.keywordsSteps().keywordsGetById(keywordId1, keywordId2);
        List<String> keywords = items.stream().map(KeywordGetItem::getKeyword).collect(Collectors.toList());
        assertThat("Ключевые фразы соотвествуют ожиданиям",
                keywords, contains(KEYWORD1_UPDATE, KEYWORD2_UPDATE));
    }
}
