package ru.yandex.autotests.directapi.keywords.update;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

/**
 * Created by semkagtn on 30.04.15.
 * https://st.yandex-team.ru/TESTIRT-4580
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-36383")
@Description("Позитивные сценарии обновления ключевых слов")
@Tag(TagDictionary.TRUNK)
public class UpdateKeywordsPositiveTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_UPDATE;
    private static final String KEYWORD = "От топата копыт пыль по полю летит";
    private static final String PARAM1 = "param1";
    private static final String PARAM2 = "param2";

    private static Long campaignId;
    private Long keywordId;
    private Long bannerId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
    }

    @Before
    public void init() {
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        bannerId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.bannersFakeSteps().makeBannersModerated(bannerId);
        keywordId = api.userSteps.keywordsSteps().addKeyword(adGroupId, KEYWORD);
    }

    @Test
    @Description("Только обязательные поля в запросе на обновление ключевого слова")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3764")
    public void updateOnlyRequiredFieldsTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(new KeywordUpdateMap()
                        .withId(keywordId)),
                ExpectedResult.success(keywordId));
    }

    @Test
    @Description("Все поля в запросе на обновление ключевого слова")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3765")
    public void updateAllKeywordFieldsTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(new KeywordUpdateMap()
                        .withId(keywordId)
                        .withKeyword(KEYWORD)
                        .withUserParam1(PARAM1)
                        .withUserParam2(PARAM2)),
                ExpectedResult.success(keywordId));
    }

    @Test
    public void updateKeywordFromArchivedGroup() {
        api.userSteps.adsSteps().adsArchive(bannerId);

        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(new KeywordUpdateMap()
                        .withId(keywordId)),
                ExpectedResult.success());
    }
}
