package ru.yandex.autotests.directapi.keywords.update;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;

/**
 * Created by semkagtn on 30.04.15.
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-36383")
@Description("Проверка предельных значений входных параметров в запросе на обновление ключевых слов")
@Tag(TagDictionary.TRUNK)
public class UpdateKeywordsRequestLimitTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_UPDATE;
    private static final int KEYWORDS_IN_REQUEST_LIMIT = 1000;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @Before
    @Step("Подготовка данных для теста")
    public void addUnitsToClient(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Число ключевых слов в запросе больше максимального")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3766")
    public void maxKeywordsInOneRequestTest() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(getKeywordMaps()),
                new Api5Error(9300,
                        Api5ErrorDetails.KEYWORD_UPDATE_REQUEST_LIMIT, KEYWORDS_IN_REQUEST_LIMIT)
        );
    }

    private KeywordUpdateMap[] getKeywordMaps(){
        KeywordUpdateMap[] keywords = new KeywordUpdateMap[KEYWORDS_IN_REQUEST_LIMIT + 1];
        for (int i = 0; i < KEYWORDS_IN_REQUEST_LIMIT + 1; i++) {
            keywords[i] = new KeywordUpdateMap()
                    .withId(0l);
        }
        return keywords;
    }
}
