package ru.yandex.autotests.directapi.keywords.update;

import java.util.Arrays;
import java.util.List;

import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;


/**
 * Created by semkagtn on 30.04.15.
 * https://st.yandex-team.ru/TESTIRT-4580
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-36383")
@Description("Проверка некорректной структуры запроса Keywords.Update")
@Tag(TagDictionary.TRUNK)
public class UpdateKeywordsStructureNegativeTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_UPDATE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN).protocol(ProtocolType.JSON);

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3768")
    public void noKeywordsElementInRequestTest() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.UPDATE,
                new UpdateRequestMap(),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(AddRequestMap.KEYWORDS)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3769")
    public void emptyKeywordsPackTest() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(null),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        path(AddRequestMap.KEYWORDS), 1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3770")
    public void integerArrayInKeywordsTest() {
        List<Integer> invalid = Arrays.asList(123, 456, 789);
        JSONObject request = new JSONObject();
        request.put("Keywords", invalid);

        api.userSteps.keywordsSteps().shouldGetKeywordErrorJsonOn(
                Action.UPDATE,
                request,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.INVALID_VALUE,
                        path(AddRequestMap.KEYWORDS)));
    }
}
