package ru.yandex.autotests.directapi.keywords.update;


import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.ActionResult;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;

import static java.util.Collections.singletonList;
import static org.hamcrest.Matchers.either;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by semkagtn on 04.03.2015.
 * https://st.yandex-team.ru/TESTIRT-4580
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-36383")
@Description("Проверка допустимых значений параметров UserParam1 и UserParam2")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateKeywordsUserParamTest {

    private static final String client = KeywordsLogins.SINGLE_CLIENT_UPDATE;

    private KeywordUpdateMap keywordMap;
    private static Long campaignID;
    private long keywordID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(0)
    public String fieldName;

    @Parameterized.Parameter(1)
    public String description;

    @Parameterized.Parameter(2)
    public String fieldValue;

    @Parameterized.Parameter(3)
    public Matcher<? super ActionResult> expectedResultMatcher;

    @Parameterized.Parameters(name = "{1}: field = {0}, value = {2}")
    public static Collection fieldsValue() throws UnsupportedEncodingException {
        Object[][] data = new Object[][]{
                {KeywordAddMap.USER_PARAM_1, "Пустая строка",
                        "",
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_1, "Строка из пробелов",
                        "  ",
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_1, "Латинские символы",
                        RandomStringUtils.randomAlphabetic(10),
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_1, "Цифровые символы",
                        RandomStringUtils.randomNumeric(10),
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_1, "Латинские и цифровые символы",
                        RandomStringUtils.randomAlphanumeric(10),
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_1, "Кириллические символы",
                        "параметр",
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_1, "Турецкие символы",
                        "türkçe",
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_1, "Спецсимволы",
                        "param/param?key=1",
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_1, "Строка с пробелом",
                        RandomStringUtils.randomAlphabetic(5) + "  " + RandomStringUtils.randomAlphabetic(5),
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_1, "Минимальная длина",
                        RandomStringUtils.randomAlphabetic(1),
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_1, "Максимальная длина",
                        RandomStringUtils.randomAlphabetic(KeywordAddMap.MAX_USER_PARAM_LENGTH),
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_1, "Длина превышает максимальную",
                        RandomStringUtils.randomAlphabetic(KeywordAddMap.MAX_USER_PARAM_LENGTH + 1),
                        either(
                                ExpectedResult.errors(new Notification(5001,
                                        Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                                        StringUtils.capitalize(KeywordAddMap.USER_PARAM_1), 255))
                                        .getActionResultMatcher())
                                .or(
                                ExpectedResult.errors(new Notification(5001,
                                        Api5ErrorDetails.FIELD_VALUE_SHOULD_NOT_BE_MORE_THAN,
                                        StringUtils.capitalize(KeywordAddMap.USER_PARAM_1), 255))
                                        .getActionResultMatcher()
                        )},
                {KeywordAddMap.USER_PARAM_1, "Кодировка UTF-8 как CP1251",
                        new String("Параметр".getBytes(Charset.forName("UTF-8")), Charset.forName("cp1251")),
                        either(
                                ExpectedResult.errors(new Notification(5002,
                                        Api5ErrorDetails.USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD_EN,
                                        path(KeywordAddMap.USER_PARAM_1))).getActionResultMatcher()
                        ).or(
                                ExpectedResult.errors(new Notification(5002,
                                        Api5ErrorDetailsJava.USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD_EN,
                                        path(KeywordAddMap.USER_PARAM_1))).getActionResultMatcher()
                        )
                },

                {KeywordAddMap.USER_PARAM_2, "Пустая строка",
                        "",
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_2, "Строка из пробелов",
                        "  ",
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_2, "Латинские символы",
                        RandomStringUtils.randomAlphabetic(10),
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_2, "Цифровые символы",
                        RandomStringUtils.randomNumeric(10),
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_2, "Латинские и цифровые символы",
                        RandomStringUtils.randomAlphanumeric(10),
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_2, "Кириллические символы",
                        "параметр",
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_2, "Турецкие символы",
                        "türkçe",
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_2, "Спецсимволы",
                        "param/param?key=1",
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_2, "Строка с пробелом",
                        RandomStringUtils.randomAlphabetic(5) + "  " + RandomStringUtils.randomAlphabetic(5),
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_2, "Минимальная длина",
                        RandomStringUtils.randomAlphabetic(1),
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_2, "Максимальная длина",
                        RandomStringUtils.randomAlphabetic(KeywordAddMap.MAX_USER_PARAM_LENGTH),
                        ExpectedResult.success().getActionResultMatcher()},
                {KeywordAddMap.USER_PARAM_2, "Длина превышает максимальную",
                        RandomStringUtils.randomAlphabetic(KeywordAddMap.MAX_USER_PARAM_LENGTH + 1),
                        either(
                                ExpectedResult.errors(new Notification(5001,
                                        Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                                        StringUtils.capitalize(KeywordAddMap.USER_PARAM_2), 255))
                                        .getActionResultMatcher())
                                .or(
                                ExpectedResult.errors(new Notification(5001,
                                        Api5ErrorDetails.FIELD_VALUE_SHOULD_NOT_BE_MORE_THAN,
                                        StringUtils.capitalize(KeywordAddMap.USER_PARAM_2), 255))
                                        .getActionResultMatcher()
                        )},
                {KeywordAddMap.USER_PARAM_2, "Кодировка UTF-8 как CP1251",
                        new String("Параметр".getBytes(Charset.forName("UTF-8")), Charset.forName("cp1251")),
                        either(
                                ExpectedResult.errors(new Notification(5002,
                                        Api5ErrorDetails.USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD_EN,
                                        path(KeywordAddMap.USER_PARAM_2))).getActionResultMatcher()
                        ).or(
                                ExpectedResult.errors(new Notification(5002,
                                        Api5ErrorDetailsJava.USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD_EN,
                                        path(KeywordAddMap.USER_PARAM_2))).getActionResultMatcher()
                        )
                }
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Before
    @Step("Создадим ключевое слово")
    public void prepareKeyword() {
        long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(groupID);
        keywordMap = new KeywordUpdateMap()
                .withId(keywordID);
        ReflectionUtils.setBeanMapFieldValue(keywordMap, "with" + StringUtils.capitalize(fieldName), fieldValue);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3778")
    public void userParamUpdateTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(keywordMap),
                singletonList(expectedResultMatcher)
        );
    }
}
