package ru.yandex.autotests.directapi.keywords.update;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

/**
 * Created by pavryabov on 25.02.16.
 * https://st.yandex-team.ru/TESTIRT-8625
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Description("Обновление нескольких ключевых слов в одном запросе с разным состоянием href_params")
@Issue("https://st.yandex-team.ru/DIRECT-51375")
public class UpdateSeveralKeywordsWithUserParamsTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_UPDATE;
    private static final String KEYWORD1 = "слово1";
    private static final String KEYWORD2 = "слово2";
    private static final String KEYWORD1_UPDATE = "слово1 слово3";
    private static final String KEYWORD2_UPDATE = "слово2 слово4";

    private static Long keywordId1;
    private static Long keywordId2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareKeyword() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        List<Long> keywordIds = api.userSteps.keywordsSteps().keywordsAdd(
                new KeywordAddMap()
                        .withAdGroupId(adGroupId)
                        .withKeyword(KEYWORD1)
                        .withUserParam1("param"),
                new KeywordAddMap()
                        .withAdGroupId(adGroupId)
                        .withKeyword(KEYWORD2));
        keywordId1 = keywordIds.get(0);
        keywordId2 = keywordIds.get(1);
    }

    @Test
    public void updateTwoKeywords() {
        //До вызова update в первом слове должны быть href_params, во втором нет
        //При вызове update в обоих словах должны расширяться фразы,
        //в первом слове присутствовать UserParams, во втором - нет
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(
                        new KeywordUpdateMap()
                                .withId(keywordId1)
                                .withKeyword(KEYWORD1_UPDATE)
                                .withUserParam1(""),
                        new KeywordUpdateMap()
                                .withKeyword(KEYWORD2_UPDATE)
                                .withId(keywordId2)),
                ExpectedResult.success(keywordId1),
                ExpectedResult.success(keywordId2));
    }
}
