package ru.yandex.autotests.directapi.keywords.update;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 12.05.15.
 * https://st.yandex-team.ru/TESTIRT-5469
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Description("Запросы на обновление ключевых слов по протоколу SOAP")
public class UpdateSoapTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_UPDATE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN).protocol(ProtocolType.SOAP);

    @Rule
    public Trashman trashman = new Trashman(api);

    @Test
    @Description("Запрос на обновление ключевых слов без поля Keywords")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3780")
    public void requestWithoutKeywordsField() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.UPDATE,
                new UpdateRequestMap()
                        .withKeywords(null),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(AddRequestMap.KEYWORDS)));
    }

    @Test
    @Description("Валидный запрос на добавление ключевого слова")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3779")
    public void correctRequest() {
        api.protocol(ProtocolType.JSON);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        long keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupID);

        api.protocol(ProtocolType.SOAP);
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap()
                        .withKeywords(new KeywordUpdateMap()
                                .withId(keywordID)),
                ExpectedResult.success(keywordID));
    }
}
