package ru.yandex.autotests.directapi.keywords.update;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerPhraseFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 11.09.16.
 * https://st.yandex-team.ru/TESTIRT-10231
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Description("Проверка StatusBsSynced группы после обновления параметров фразы")
@RunWith(Parameterized.class)
public class UpdateUserParamsAndCheckStatusBsSynced {

    private static final String client = KeywordsLogins.SINGLE_CLIENT_UPDATE;

    private static Long campaignId;

    private Long adGroupId;
    private Long keywordId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String oldUserParam1;

    @Parameterized.Parameter(value = 1)
    public String newUserParam1;

    @Parameterized.Parameter(value = 2)
    public String oldUserParam2;

    @Parameterized.Parameter(value = 3)
    public String newUserParam2;

    @Parameterized.Parameter(value = 4)
    public String expectedStatusBsSynced;

    @Parameterized.Parameters(name = "oldUserParam1 = {0}, newUserParam1 = {1}, oldUserParam2 = {2}, newUserParam2 = {3}")
    public static Collection fields() {
        Object[][] data = new Object[][]{
                {"param1", "newParam1", "param2", "param2", Status.NO},
                {"param1", "param1", "param2", "newParam2", Status.NO},
                {"param1", "newParam1", "param2", "newParam2", Status.NO},
                {"param1", "param1", "param2", "param2", Status.YES}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareKeyword() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Step("подготовка данных для теста")
    @Before
    public void prepareData() {
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);

        keywordId = api.userSteps.keywordsSteps().keywordsAdd(new KeywordAddMap()
                .withAdGroupId(adGroupId)
                .withKeyword("keyword")
                .withUserParam1(oldUserParam1)
                .withUserParam2(oldUserParam2)).get(0);

        DirectJooqDbSteps directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(client);

        api.userSteps.phrasesFakeSteps().setStatusBsSynced(keywordId, Status.YES);
        api.userSteps.bannersFakeSteps().makeBannersActiveAndFullyModerated(adId);
        directJooqDbSteps.adGroupsSteps().makePhraseModeratedAndBsSynced(adGroupId);
        api.userSteps.campaignFakeSteps().makeCampaignActive(campaignId);

        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap()
                        .withKeywords(new KeywordUpdateMap()
                                .withId(keywordId)
                                .withUserParam1(newUserParam1)
                                .withUserParam2(newUserParam2)),
                ExpectedResult.success());
    }

    @Test
    public void checkAdGroupStatusBsSynced() {
        GroupFakeInfo groupInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assertThat("у группы верный StatusBsSynced",
                groupInfo.getStatusBsSynced(), equalTo(expectedStatusBsSynced));
    }

    @Test
    public void checkKeywordStatusBsSynced() {
        BannerPhraseFakeInfo phraseFakeInfo = api.userSteps.phrasesFakeSteps().getBannerPhraseParams(keywordId);
        assertThat("у группы верный StatusBsSynced",
                phraseFakeInfo.getStatusBsSynced(), equalTo(Status.YES));
    }
}
