package ru.yandex.autotests.directapi.keywords.update.keyword;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;

import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;

/**
 * Created by semkagtn on 30.04.15.
 * https://st.yandex-team.ru/TESTIRT-4580
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-36383")
@Description("Обновление ключевых слов со сложными сочетаниями скобок [] - фиксации порядка слов")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateKeywordsComplicatedBracketsTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_UPDATE;
    private static Long campaignID;

    private long keywordID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameter(0)
    public String keywordValue;

    @Parameter(1)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameters(name = "test = {0}")
    public static Collection fields() {
        Object[][] data = new Object[][]{
                // TODO
                {"[билет в питер]",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(new Notification(10141)))},
                {"[питер]",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(new Notification(10141)))},

                {"[!питер]",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(new Notification(10141)))},

                {"\"[билет в питер]\"",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(new Notification(10141)))},

                {"купить [билет в питер]",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(new Notification(10141)))},

                {"\"купить [билет в питер]\"",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(new Notification(10141)))},

                {"купить [билет в питер] -авиабилет ",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(new Notification(10141)))},

                {"купить [билет в !питер]",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(new Notification(10141)))},

                {"[билет в питер][купить дешево]",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(5002,
                                        Api5ErrorDetailsJava.SQUARE_BRACKETS_COULD_NOT_BE_EMPTY_OR_EMBEDDED,
                                        "[билет в питер][купить дешево]")))
                                .perl(
                                ExpectedResult.errors(new Notification(5161,
                                        Api5ErrorDetails.KEYWORD_INCORRECT_COMBINATION_OF_CHARACTERS,
                                        "[билет в питер][купить дешево]")))},
//                {"[билет в питер [купить] дешево]", ExpectedResult.warnings(new Notification(10141))},
                {"[билет на самолет] !питер -купить",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(new Notification(10141)))},
                {"купить [билет в !питере] +на спектакль",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(new Notification(10141)))},
                {"[(купить|продать) (авто|мото)]",
                        JavaOrPerlExpectedResult.both(
                                ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.INVALID_KEYWORD_SYMBOLS,
                                        "[(купить|продать) (авто|мото)]")))},
//                {"[\"купить билет\"]",
//                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.UNACCEPTABLE_SYMBOLS_USED_IN_SQUARE_BRACKETS, "[\"купить билет\"]"))},
                {"[билет +в питер]",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(5002,
                                        Api5ErrorDetailsJava.UNACCEPTABLE_SYMBOLS_USED_IN_SQUARE_BRACKETS,
                                        "[билет +в питер]")))
                                .perl(ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetails.UNACCEPTABLE_SYMBOLS_USED_IN_SQUARE_BRACKETS,
                                "[билет +в питер]")))},
//                {"[купить билет -питер]",
//                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.UNACCEPTABLE_SYMBOLS_USED_IN_SQUARE_BRACKETS, "[купить билет -питер]"))},
//                {"билет ![купить дешево]",
//                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.KEYWORD_INCORRECT_COMBINATION_OF_CHARACTERS, "билет ![купить дешево]"))},
//                {"\"в питер\" [купить билет]",
//                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.KEYWORD_INCORRECT_USAGE_OF_QUOTES, "\"в питер\" [купить билет]"))},
//                {"купить [\"билет в питер\"]",
//                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.KEYWORD_INCORRECT_USAGE_OF_QUOTES, "купить [\"билет в питер\"]"))},
//                {"[[]",
//                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.SQUARE_BRACKETS_COULD_NOT_BE_EMPTY_OR_EMBEDDED, "[[]"))},
//                {"[]",
//                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.SQUARE_BRACKETS_COULD_NOT_BE_EMPTY_OR_EMBEDDED, "[]"))},
//                {"[[[]]]",
//                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.SQUARE_BRACKETS_COULD_NOT_BE_EMPTY_OR_EMBEDDED, "[[[]]]"))},
//                {"купить билеты []",
//                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.SQUARE_BRACKETS_COULD_NOT_BE_EMPTY_OR_EMBEDDED, "купить билеты []"))},
//                {"[[билет в питер]",
//                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.SQUARE_BRACKETS_COULD_NOT_BE_EMPTY_OR_EMBEDDED, "[[билет в питер]"))}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareKeyword() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(groupID);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3781")
    public void keywordBracketsTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(new KeywordUpdateMap()
                        .withId(keywordID)
                        .withKeyword(keywordValue)),
                expectedResult);
    }
}
