package ru.yandex.autotests.directapi.keywords.update.keyword;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;

import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;

/**
 * Created by semkagtn on 30.04.15.
 * https://st.yandex-team.ru/TESTIRT-4580
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-36383")
@Description("Обновление текста ключевых слов")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateKeywordsKeywordTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_UPDATE;
    private static Long campaignID;

    private long keywordID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameter(0)
    public String description;

    @Parameter(1)
    public String keywordValue;

    @Parameter(2)
    public ExpectedResult expectedResult;

    @Parameters(name = "test = {0}")
    public static Collection fields() {
        String badEncoding = new String("Параметр".getBytes(Charset.forName("UTF-8")), Charset.forName("cp1251"));
        Object[][] data = new Object[][]{
                // TODO
                {"Пустая строка", "",
                        ExpectedResult.errors(new Notification(5000, Api5ErrorDetails.NO_VALUE_IN_FIELD,
                                StringUtils.capitalize(KeywordAddMap.KEYWORD)))},
                {"Строка из пробела", " ",
                        ExpectedResult.errors(new Notification(5000, Api5ErrorDetails.NO_VALUE_IN_FIELD,
                                StringUtils.capitalize(KeywordAddMap.KEYWORD)))},
                {"Латинские символы", "window",
                        ExpectedResult.success()},
                {"Кириллические символы", "проездной",
                        ExpectedResult.success()},
                {"Турецкие символы", "müthişreklamÇĞğÖŞÜ",
                        ExpectedResult.success()},
                {"Белорусские символы", "аплата наяўнымі",
                        ExpectedResult.success()},
                {"Цифровые символы", RandomStringUtils.randomNumeric(10),
                        ExpectedResult.success()},
                {"Латинские и цифровые символы", RandomStringUtils.randomAlphanumeric(10),
                        ExpectedResult.success()},
                {"Ключевое заканчивается символом .", "кирпич.",
                        ExpectedResult.success()},
                {"Ключевое начинается с символа .", ".Net",
                        ExpectedResult.errors(new Notification(5161,
                                Api5ErrorDetails.MINUS_PHRASES_COULD_NOT_START_WITH_DOT_OR_APOSTROPHE, "\".Net\""))},
                {"Использование символа '", "rock'n'roll детка",
                        ExpectedResult.success()},
                {"Ключевое начинается с символа '", "'window",
                        ExpectedResult.errors(new Notification(5161,
                                Api5ErrorDetails.MINUS_PHRASES_COULD_NOT_START_WITH_DOT_OR_APOSTROPHE,
                                "\"'window\""))},
                {"Ключевое заканчивается символом '", "window'",
                        ExpectedResult.success()},
                {"Ключевое состоящее из более 7 слов",
                        "неожиданные структурные перекосы экономически опосредованной объективной реальности России",
                        ExpectedResult.errors(
                                new Notification(5140, Api5ErrorDetails.KEYWORD_COULD_NOT_CONTAIN_MORE_WORDS,
                                        "неожиданные структурные перекосы экономически опосредованной объективной реальности России"))},
                {"Пробелы в начале и конце", "    рефераты ",
                        ExpectedResult.success()},
                {"Пробел в середине", "пластикове  окна",
                        ExpectedResult.success()},
                {"Ключевое из стоп-слова с символом 'ё'", "всё",
                        ExpectedResult.errors(
                                new Notification(5141,
                                        Api5ErrorDetails.KEYWORD_COULD_NOT_CONSIST_OF_STOPWORDS_ONLY,
                                        "все"))},
                {"Ключевое содержит стоп-слово", "мир всем",
                        ExpectedResult.success()},
                {"Ключевое из стоп-слов", "все мне",
                        ExpectedResult.errors(
                                new Notification(5141,
                                        Api5ErrorDetails.KEYWORD_COULD_NOT_CONSIST_OF_STOPWORDS_ONLY,
                                        "все мне"))},
                {"Использование стоп-слов", "товары +для автомобиля",
                        ExpectedResult.success()},
                {"Фиксация словоформы одиночное", "!искусный",
                        ExpectedResult.success()},
                {"Фиксация словоформы несколько", "макияж !трафарет ",
                        ExpectedResult.success()},
                {"С учётом словоформ одиночное", "\"влюбленный\"",
                        ExpectedResult.success()},
//                {"С учётом словоформ некорректное", "котята \"шредингера купить\"",
//                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.KEYWORD_INCORRECT_USAGE_OF_QUOTES, "котята \"шредингера купить\""))},
                {"C учётом словоформ несколько", "\"котята шредингера купить\"",
                        ExpectedResult.success()},
                {"С учетом словоформ и фиксацией", "\"!пенобетон\"",
                        ExpectedResult.success()},
                {"C учётом словоформ и стоп-слов", "\"решетка +для камина\"",
                        ExpectedResult.success()},
//                {"Некорректное использование символа !", "! Шостакович",
//                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.INCORRECT_USE_OF_SYMBOL_IN_KEYWORD, "!", "! Шостакович"))},
//                {"Некорректное использование символа +", "портальные + краны",
//                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.INCORRECT_USE_OF_SYMBOL_IN_KEYWORD, "+", "портальные + краны"))},
                {"C учётом словоформ лишние кавычки", "\"омывающая жидкость\"\"",
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetails.KEYWORD_INCORRECT_USAGE_OF_QUOTES,
                                "\"омывающая жидкость\"\""))},
                {"Использование группировки", "ремонт (автомобилей | машин)",
                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.INVALID_KEYWORD_SYMBOLS,
                                "ремонт (автомобилей | машин)"))},
//                {"Кодировка UTF-8 как CP1251", badEncoding,
//                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.INVALID_KEYWORD_SYMBOLS, badEncoding))}

        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareKeyword() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(groupID);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3783")
    public void keywordsTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(new KeywordUpdateMap()
                        .withId(keywordID)
                        .withKeyword(keywordValue)),
                expectedResult);
    }
}
