package ru.yandex.autotests.directapi.keywords.update.keyword;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;

/**
 * Created by semkagtn on 30.04.15.
 * https://st.yandex-team.ru/TESTIRT-4580
 */
@Aqua.Test
@Features(KeywordsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-36383")
@Description("Обновление минус-слов в ключевых словах")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateKeywordsMinusWordTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_UPDATE;
    private static Long campaignID;

    private long keywordID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String keywordValue;

    @Parameterized.Parameter(value = 2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection fields() {
        Object[][] data = new Object[][]{
                {"Ключевое с минус-словом", "остекление -балкон",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(new Notification(10141)))},
                {"Ключевое с минусом из стоп-слова", "мультики -все",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(new Notification(10141)))},
                {"Ключевое с минусом из стоп-слова с символом 'ё'", "хаски -всё",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(new Notification(10141)))},
                {"Ключевое с несколькими минус-словами", "остекление -балкон -окно -витраж",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(new Notification(10141)))},
                {"Ключевое с одинаковыми минус-словами", "ремонт -бесплатный -бесплатный",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(new Notification(10141)))},
                {"Ключевые слова с минус-словом", "остекление лоджий -срочное",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(new Notification(10141)))},
                {"Минус-слово с фиксацией словоформы", "остекление -!балконов",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(new Notification(10141)))},
                {"Минус-слово исключающее ключевое", "балкон -балкон",
                        JavaOrPerlExpectedResult.both(
                                ExpectedResult.errors(new Notification(5161,
                                        Api5ErrorDetails.KEYWORD_COULD_NOT_BE_USED_AS_MINUS_WORD, "балкон",
                                        "балкон -балкон")))},
                {"Ключевое слово предваряется минус-словом", "высокий -полет квадрокоптер",
                        JavaOrPerlExpectedResult.both(
                                ExpectedResult.errors(new Notification(5161,
                                        Api5ErrorDetails.ONLY_SEPARATE_WORDS_COULD_BE_EXCLUDED,
                                        "высокий -полет квадрокоптер")))},
                {"Минус-слово без ключевого", "-балкон",
                        JavaOrPerlExpectedResult.both(
                                ExpectedResult.errors(new Notification(5161,
                                        Api5ErrorDetails.KEYWORD_COULD_NOT_CONSIST_OF_NEGATIVE_KEYWORDS_ONLY,
                                        "-балкон")))},
                {"Некорректное использование символа '-'", "балкон - остекление",
                        JavaOrPerlExpectedResult
                                .java(
                                        ExpectedResult.errors(
                                                new Notification(5002,
                                                        Api5ErrorDetails.INCORRECT_USE_OF_SYMBOL_IN_KEYWORD, "-",
                                                        "балкон - остекление"))
                                )
                                .perl(
                                ExpectedResult.errors(
                                        new Notification(5002, Api5ErrorDetails.INCORRECT_USE_OF_SYMBOL_IN_KEYWORD, "-",
                                                "балкон - остекление"),
                                        new Notification(5161, Api5ErrorDetails.ONLY_SEPARATE_WORDS_COULD_BE_EXCLUDED,
                                                "балкон - остекление")))},
                {"Простая группировка с минус-словами", "сервисное обслуживание (Kia | Ford) -гарантийное -бесплатное",
                        JavaOrPerlExpectedResult.both(
                                ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.INVALID_KEYWORD_SYMBOLS,
                                        "сервисное обслуживание (Kia | Ford) -гарантийное -бесплатное")))},
                {"Ключевое с минус-словом на белорусском", "аплата -наяўнымі",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(new Notification(10141)))},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareKeyword() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(groupID);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3784")
    public void keywordMinusWordsTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withKeywords(new KeywordUpdateMap()
                        .withId(keywordID)
                        .withKeyword(keywordValue)),
                expectedResult);
    }
}
