package ru.yandex.autotests.directapi.keywordsresearch.deduplicate;

import java.util.Arrays;
import java.util.List;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.keywordsresearch.KeywordsResearchFeatures;
import ru.yandex.autotests.directapi.keywordsresearch.KeywordsResearchLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.DeduplicateRequestItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.DeduplicateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

@Aqua.Test
@Features(KeywordsResearchFeatures.CHECK_LOGIN_POSSIBLE)
@Description("Негативный тест на возможность доступа к ручке KeywordsResearch.deduplicate")
@RunWith(Parameterized.class)
public class CanLoginAgencyClientNegativeTest {
    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @Parameterized.Parameter
    public String login;
    @Parameterized.Parameter(1)
    public String clientLogin;
    @Parameterized.Parameter(2)
    public Api5Error result;
    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameters(name = "operator: {0}, client: {1}")
    public static List<Object[]> parameters() {
        return Arrays.asList(
                new Object[]{
                        KeywordsResearchLogins.CLIENT,
                        KeywordsResearchLogins.SUBCLIENT,
                        new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)},
                new Object[]{
                        KeywordsResearchLogins.CLIENT,
                        KeywordsResearchLogins.AGENCY,
                        new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)},
                new Object[]{
                        KeywordsResearchLogins.AGENCY,
                        KeywordsResearchLogins.AGENCY_YE_DEFAULT,
                        new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)},
                new Object[]{
                        KeywordsResearchLogins.AGENCY,
                        KeywordsResearchLogins.CLIENT,
                        new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)}
        );
    }

    @Test
    public void loginPossibleAsClientTest() {
        DeduplicateRequestMap requestMap = prepareRequest();
        api.as(login).userSteps.keywordsResearchSteps().shouldGetErrorOn(clientLogin,
                Action.DEDUPLICATE, requestMap, result);
    }

    private DeduplicateRequestMap prepareRequest() {
        return new DeduplicateRequestMap()
                .withKeywords(new DeduplicateRequestItemMap().withKeyword("ключевая фраза"));
    }
}
